/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Items;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Items.ItemCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Tools.Help.String.Str;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.LocaleHelper;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Enchant
extends ItemCommand {
    private static final List<String> enchantList = new ArrayList<String>();

    public Enchant() {
        this.permNode = "admincmd.item.enchant";
        this.cmdName = "bal_enchant";
        this.other = true;
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws PlayerNotFound, ActionNotPermitedException {
        ItemStack itemInHand;
        int lvl;
        Player target = Utils.getUserParam(sender, args, this.permNode);
        if (args.length == 0) {
            sender.sendMessage(ChatColor.YELLOW + "Echantment list :");
            sender.sendMessage(ChatColor.GOLD + Joiner.on((String)", ").skipNulls().join(enchantList).toLowerCase());
            return;
        }
        String enchantString = args.getString(0);
        try {
            lvl = args.getInt(1);
        }
        catch (NumberFormatException e) {
            lvl = 1;
        }
        String found = Str.matchString(enchantList, enchantString);
        HashMap<String, String> replace = new HashMap<String, String>();
        if (found == null) {
            replace.put("value", enchantString);
            replace.put("type", LocaleHelper.TYPE_ENCHANTMENT.getLocale());
            LocaleHelper.DONT_EXISTS.sendLocale(sender, replace);
            sender.sendMessage(ChatColor.YELLOW + "Echantment list :");
            sender.sendMessage(ChatColor.GOLD + Joiner.on((String)", ").skipNulls().join(enchantList).toLowerCase());
            return;
        }
        Enchantment enchantment = Enchantment.getByName((String)found);
        if (!enchantment.canEnchantItem(itemInHand = target.getItemInHand())) {
            replace.put("item", itemInHand.getType().toString());
            replace.put("enchant", enchantment.getName());
            LocaleHelper.CANT_ENCHANT.sendLocale(sender, replace);
            return;
        }
        itemInHand.addUnsafeEnchantment(enchantment, lvl);
        replace.put("item", itemInHand.getType().toString());
        replace.put("enchant", enchantment.getName());
        replace.put("lvl", String.valueOf(lvl));
        LocaleHelper.SUCCESS_ENCHANT.sendLocale(sender, replace);
        if (!sender.equals(target)) {
            LocaleHelper.SUCCESS_ENCHANT.sendLocale((CommandSender)target, replace);
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }

    static {
        for (Enchantment enchant : Enchantment.values()) {
            enchantList.add(enchant.getName());
        }
    }
}

