/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.CoreCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Tools.Debug.ACLogger;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ACCommandContainer {
    private final CommandSender sender;
    private final CoreCommand cmd;
    private CommandArgs args = null;
    private final String[] argsStrings;

    public ACCommandContainer(CommandSender sender, CoreCommand cmd, String[] args) {
        this.sender = sender;
        this.cmd = cmd;
        this.argsStrings = args;
    }

    public void processArguments() {
        if (this.args == null) {
            try {
                this.args = new CommandArgs(this.argsStrings);
            }
            catch (Exception e) {
                ACLogger.severe("Problem in parsing the commandString", e);
            }
        }
    }

    public void execute() throws PlayerNotFound, ActionNotPermitedException {
        if (ConfigEnum.LOG_CMD.getBoolean()) {
            String name = "Console";
            if (this.sender instanceof Player) {
                name = ((Player)this.sender).getName();
            }
            ACLogger.info(name + " [CMD: " + this.cmd.getCmdName() + "] (ARGS:" + this.args.toString() + ")");
        }
        this.cmd.execute(this.sender, this.args);
    }

    public String debug() {
        return "[Plugin Version: " + ACHelper.getInstance().getCoreInstance().getDescription().getVersion() + "][" + Thread.currentThread().getName() + "] The command " + (this.cmd != null ? this.cmd.getCmdName() : "command=null") + " " + (this.args != null ? this.args.toString() : "args=null") + " throw an Exception please report the log in a ticket : http://bug.admincmd.com/";
    }

    public CommandSender getSender() {
        return this.sender;
    }

    public Class<? extends CoreCommand> getCommandClass() {
        return this.cmd.getClass();
    }

    public String toString() {
        return "ACCommandContainer [sender=" + this.sender + ", cmd=" + this.cmd + ", args=" + this.args + "]";
    }
}

