/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager;

import be.Balor.Manager.Commands.ACCommandContainer;
import be.Balor.Manager.Commands.CommandAlias;
import be.Balor.Manager.Commands.CoreCommand;
import be.Balor.Manager.Exceptions.CommandAlreadyExist;
import be.Balor.Manager.Exceptions.CommandDisabled;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Exceptions.WorldNotLoaded;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.ClassUtils;
import be.Balor.Tools.Configuration.ExConfigurationSection;
import be.Balor.Tools.Configuration.File.ExtendedConfiguration;
import be.Balor.Tools.Debug.ACLogger;
import be.Balor.Tools.Debug.DebugLog;
import be.Balor.Tools.Files.FileManager;
import be.Balor.Tools.Files.PluginCommandUtil;
import be.Balor.Tools.Help.HelpLister;
import be.Balor.Tools.Metrics.ClassPlotter;
import be.Balor.Tools.Metrics.IncrementalPlotter;
import be.Balor.Tools.Metrics.Metrics;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.AbstractAdminCmdPlugin;
import be.Balor.bukkit.AdminCmd.AdminCmd;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import be.Balor.bukkit.AdminCmd.LocaleHelper;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandManager
implements CommandExecutor {
    private final HashMap<Command, CoreCommand> registeredCommands = new HashMap();
    private final int MAX_THREADS = 8;
    private static CommandManager instance = new CommandManager();
    private Metrics.Graph graph;
    private AbstractAdminCmdPlugin corePlugin;
    private boolean threadsStarted = false;
    private List<String> disabledCommands;
    private List<String> prioritizedCommands;
    private final Map<String, CommandAlias> commandsAliasReplacer = new HashMap<String, CommandAlias>();
    private final Map<String, Set<CommandAlias>> commandsAlias = new HashMap<String, Set<CommandAlias>>();
    private final ThreadPoolExecutor threads = new ThreadPoolExecutor(2, 8, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(true));
    private final Map<AbstractAdminCmdPlugin, Map<String, Command>> pluginCommands = new HashMap<AbstractAdminCmdPlugin, Map<String, Command>>();
    private final Map<Class<? extends CoreCommand>, IncrementalPlotter> plotters = new HashMap<Class<? extends CoreCommand>, IncrementalPlotter>();

    public static CommandManager getInstance() {
        return instance;
    }

    public static CommandManager createInstance() {
        if (instance == null) {
            instance = new CommandManager();
        }
        return instance;
    }

    public static void killInstance() {
        instance = null;
    }

    private CommandManager() {
    }

    public void checkAlias(AbstractAdminCmdPlugin plugin) {
        Map<String, Command> commands;
        if (ConfigEnum.VERBOSE.getBoolean() && (commands = this.pluginCommands.get((Object)plugin)) != null) {
            for (String cmdName : commands.keySet()) {
                Command cmd = commands.get(cmdName);
                if (this.corePlugin.getCommand(cmd.getName()) == null) continue;
                ArrayList aliasesList = new ArrayList(cmd.getAliases());
                aliasesList.removeAll(this.corePlugin.getCommand(cmd.getName()).getAliases());
                aliasesList.removeAll(this.prioritizedCommands);
                String aliases = "";
                for (String alias : aliasesList) {
                    aliases = aliases + alias + ", ";
                }
                if (aliases.isEmpty() || !ConfigEnum.VERBOSE.getBoolean()) continue;
                Logger.getLogger("Minecraft").info("[" + this.corePlugin.getDescription().getName() + "] Disabled Alias(es) for " + cmd.getName() + " : " + aliases);
            }
        }
    }

    private void checkCommand(CoreCommand command) throws CommandDisabled {
        Map<String, Command> commands = this.pluginCommands.get((Object)command.getPlugin());
        if (commands != null) {
            for (String alias : commands.get(command.getCmdName()).getAliases()) {
                Set<CommandAlias> commandAliases;
                if (this.disabledCommands.contains(alias)) {
                    throw new CommandDisabled("Command " + command.getCmdName() + " selected to be disabled in the configuration file.");
                }
                if (this.prioritizedCommands.contains(alias)) {
                    CommandAlias cmd = new CommandAlias(command.getCmdName(), alias, "");
                    cmd.setCmd(command);
                    this.commandsAliasReplacer.put(alias, cmd);
                }
                if ((commandAliases = this.commandsAlias.get(alias)) == null) continue;
                for (CommandAlias commandAlias : commandAliases) {
                    commandAlias.setCmd(command);
                }
            }
        }
    }

    private boolean executeCommand(CommandSender sender, CoreCommand cmd, String[] args) {
        ACCommandContainer container = null;
        try {
            if (!cmd.permissionCheck(sender)) {
                return true;
            }
            if (!cmd.argsCheck(args)) {
                return HelpLister.getInstance().displayExactCommandHelp(sender, "AdminCmd", cmd.getCmdName());
            }
            container = new ACCommandContainer(sender, cmd, args);
            this.threads.execute(new NormalCommand(container));
            if (!cmd.getCmdName().equals("bal_repeat")) {
                if (Utils.isPlayer(sender, false)) {
                    ACPlayer.getPlayer((Player)sender).setLastCmd(container);
                } else {
                    ACPlayer.getPlayer("serverConsole").setLastCmd(container);
                }
            }
            return true;
        }
        catch (Throwable t) {
            ACLogger.severe(container != null ? container.debug() : "The container is null", t);
            Utils.broadcastMessage("[AdminCmd] " + container != null ? container.debug() : cmd.getCmdName() + " throw an Exception please report the log in a ticket : http://bug.admincmd.com/");
            return false;
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        CoreCommand cmd = null;
        cmd = this.registeredCommands.get(command);
        if (cmd != null) {
            return this.executeCommand(sender, cmd, args);
        }
        return false;
    }

    public boolean processCommandString(CommandSender sender, String command) {
        String[] split = command.split("\\s+");
        if (split.length == 0) {
            return false;
        }
        String cmdName = split[0].substring(1).toLowerCase();
        CommandAlias cmdAlias = this.commandsAliasReplacer.get(cmdName);
        if (cmdAlias != null) {
            if (ConfigEnum.VERBOSE.getBoolean()) {
                ACLogger.info("Command " + cmdName + " intercepted for " + cmdAlias.getCommandName());
            }
            String[] cmdArgsArray = Utils.Arrays_copyOfRange(split, 1, split.length);
            CoreCommand coreCmd = cmdAlias.getCmd();
            if (!coreCmd.argsCheck(cmdArgsArray)) {
                if (!HelpLister.getInstance().displayExactCommandHelp(sender, "AdminCmd", coreCmd.getCmdName())) {
                    sender.sendMessage(coreCmd.getPluginCommand().getUsage().replace("<command>", cmdName));
                }
                return true;
            }
            return this.executeCommand(sender, coreCmd, cmdAlias.processArguments(cmdArgsArray));
        }
        return false;
    }

    public void registerACPlugin(AbstractAdminCmdPlugin plugin) {
        HashMap<String, Command> commands = new HashMap<String, Command>();
        for (Command cmd : PluginCommandUtil.parse((Plugin)plugin)) {
            commands.put(cmd.getName(), cmd);
        }
        this.pluginCommands.put(plugin, new HashMap(commands));
    }

    public boolean registerCommand(Class<? extends CoreCommand> clazz) {
        CoreCommand command = null;
        try {
            DebugLog.INSTANCE.info("Begin registering Command " + clazz.getName());
            command = clazz.newInstance();
            command.initializeCommand();
            this.checkCommand(command);
            command.registerBukkitPerm();
            command.getPluginCommand().setExecutor((CommandExecutor)instance);
            this.registeredCommands.put((Command)command.getPluginCommand(), command);
            ClassPlotter plotter = new ClassPlotter(clazz);
            this.graph.addPlotter(plotter);
            this.plotters.put(clazz, plotter);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return false;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return false;
        }
        catch (CommandDisabled e) {
            this.unRegisterBukkitCommand(command.getPluginCommand());
            HelpLister.getInstance().removeHelpEntry(command.getPlugin().getPluginName(), command.getCmdName());
            if (ConfigEnum.VERBOSE.getBoolean()) {
                ACLogger.info(e.getMessage());
            }
            return false;
        }
        catch (CommandAlreadyExist e) {
            boolean disableCommand = true;
            Map<String, Command> commands = this.pluginCommands.get((Object)command.getPlugin());
            if (commands != null) {
                for (String alias : commands.get(command.getCmdName()).getAliases()) {
                    Set<CommandAlias> commandAliases;
                    if (this.prioritizedCommands.contains(alias)) {
                        CommandAlias cmd = new CommandAlias(command.getCmdName(), alias, "");
                        cmd.setCmd(command);
                        this.commandsAliasReplacer.put(alias, cmd);
                        disableCommand = false;
                    }
                    if ((commandAliases = this.commandsAlias.get(alias)) == null) continue;
                    for (CommandAlias commandAlias : commandAliases) {
                        commandAlias.setCmd(command);
                    }
                    disableCommand = false;
                }
            }
            if (disableCommand) {
                this.unRegisterBukkitCommand(command.getPluginCommand());
                HelpLister.getInstance().removeHelpEntry(command.getPlugin().getPluginName(), command.getCmdName());
                if (ConfigEnum.VERBOSE.getBoolean()) {
                    ACLogger.info(e.getMessage());
                }
                DebugLog.INSTANCE.info("Command Disabled");
                return false;
            }
            command.registerBukkitPerm();
            command.getPluginCommand().setExecutor((CommandExecutor)this);
            this.registeredCommands.put((Command)command.getPluginCommand(), command);
            DebugLog.INSTANCE.info("Command Prioritized but already exists");
            ClassPlotter plotter = new ClassPlotter(clazz);
            this.graph.addPlotter(plotter);
            this.plotters.put(clazz, plotter);
            return true;
        }
        catch (CommandException e) {
            if (ConfigEnum.VERBOSE.getBoolean()) {
                Logger.getLogger("Minecraft").info("[AdminCmd] " + e.getMessage());
            }
            return false;
        }
        DebugLog.INSTANCE.info("End registering Command " + clazz.getName());
        return true;
    }

    public void setCorePlugin(AdminCmd plugin) {
        this.corePlugin = plugin;
        ExtendedConfiguration cmds = FileManager.getInstance().getYml("commands");
        this.disabledCommands = cmds.getStringList("disabledCommands", new LinkedList<String>());
        this.prioritizedCommands = cmds.getStringList("prioritizedCommands", new LinkedList<String>());
        ExConfigurationSection aliases = cmds.getConfigurationSection("aliases");
        for (String command : aliases.getKeys(false)) {
            Set<CommandAlias> setAliasCmd = this.commandsAlias.get(command);
            if (setAliasCmd == null) {
                setAliasCmd = new HashSet<CommandAlias>();
                this.commandsAlias.put(command, setAliasCmd);
            }
            ExConfigurationSection aliasSection = aliases.getConfigurationSection(command);
            for (Map.Entry alias : aliasSection.getValues(false).entrySet()) {
                CommandAlias commandAlias = new CommandAlias(command, (String)alias.getKey(), alias.getValue().toString());
                this.commandsAliasReplacer.put((String)alias.getKey(), commandAlias);
                setAliasCmd.add(commandAlias);
            }
        }
        this.graph = plugin.getMetrics().createGraph("Commands");
        this.startThreads();
    }

    public void startThreads() {
        if (!this.threadsStarted) {
            this.threads.purge();
        }
        this.threadsStarted = true;
    }

    public void stopAllExecutorThreads() {
        this.threads.shutdown();
        this.threadsStarted = false;
    }

    private void unRegisterBukkitCommand(PluginCommand pCmd) {
        try {
            PluginCommand cmd;
            SimpleCommandMap commandMap = (SimpleCommandMap)ClassUtils.getPrivateField(this.corePlugin.getServer().getPluginManager(), "commandMap");
            HashMap knownCommands = (HashMap)ClassUtils.getPrivateField(commandMap, "knownCommands");
            try {
                cmd = (PluginCommand)knownCommands.get(pCmd.getName());
                if (cmd != null && cmd.getExecutor().equals(this)) {
                    knownCommands.remove(pCmd.getName());
                }
            }
            catch (ClassCastException e) {
                DebugLog.INSTANCE.log(Level.INFO, "Not a Plugin Command", e);
            }
            for (String alias : pCmd.getAliases()) {
                try {
                    cmd = (PluginCommand)knownCommands.get(alias);
                    if (cmd == null || !cmd.getExecutor().equals(this)) continue;
                    knownCommands.remove(alias);
                }
                catch (ClassCastException e) {
                    DebugLog.INSTANCE.log(Level.INFO, "Not a Plugin Command", e);
                }
            }
        }
        catch (SecurityException e) {
            ACLogger.severe("Unregistering command problem", e);
        }
        catch (IllegalArgumentException e) {
            ACLogger.severe("Unregistering command problem", e);
        }
        catch (NoSuchFieldException e) {
            ACLogger.severe("Unregistering command problem", e);
        }
        catch (IllegalAccessException e) {
            ACLogger.severe("Unregistering command problem", e);
        }
        catch (Exception e) {
            ACLogger.severe("Unregistering command problem", e);
        }
    }

    public boolean unRegisterCommand(Class<? extends CoreCommand> clazz, AbstractAdminCmdPlugin plugin) {
        block5: {
            try {
                CoreCommand command = clazz.newInstance();
                if (!plugin.equals((Object)command.getPlugin())) break block5;
                try {
                    command.initializeCommand();
                    PluginCommand pCmd = command.getPluginCommand();
                    this.registeredCommands.remove(pCmd);
                    this.removeFromAliasReplacer(command);
                    this.unRegisterBukkitCommand(pCmd);
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return false;
    }

    private void removeFromAliasReplacer(CoreCommand command) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (Map.Entry<String, CommandAlias> entry : this.commandsAliasReplacer.entrySet()) {
            if (!entry.getValue().getCmd().equals(command)) continue;
            keysToRemove.add(entry.getKey());
        }
        for (String key : keysToRemove) {
            this.commandsAliasReplacer.remove(key);
        }
    }

    private class SyncCommand
    extends NormalCommand {
        public SyncCommand(ACCommandContainer acc) {
            super(acc);
        }

        @Override
        public void run() {
            try {
                this.processCmd();
            }
            catch (WorldNotLoaded e) {
                ACLogger.severe("World not Loaded", e);
                Utils.broadcastMessage("[AdminCmd] World " + e.getMessage() + " is not loaded.");
            }
            catch (Throwable t) {
                ACLogger.severe(this.acc.debug(), t);
                Utils.broadcastMessage("[AdminCmd] " + this.acc.debug());
            }
        }

        @Override
        public String toString() {
            return "SyncCommand [acc=" + this.acc + "]";
        }
    }

    private class NormalCommand
    implements Runnable {
        protected final ACCommandContainer acc;

        public NormalCommand(ACCommandContainer acc) {
            this.acc = acc;
        }

        protected void processCmd() throws PlayerNotFound, ActionNotPermitedException {
            this.acc.processArguments();
            this.acc.execute();
        }

        @Override
        public void run() {
            try {
                this.processCmd();
                ((IncrementalPlotter)CommandManager.this.plotters.get(this.acc.getCommandClass())).increment();
            }
            catch (ConcurrentModificationException cme) {
                ACPluginManager.getScheduler().scheduleSyncDelayedTask((Plugin)CommandManager.this.corePlugin, (Runnable)new SyncCommand(this.acc));
            }
            catch (WorldNotLoaded e) {
                String message = e.getMessage();
                if (message == null || message == "") {
                    message = "This world is not loaded!";
                }
                HashMap<String, String> replace = new HashMap<String, String>();
                replace.put("message", message);
                LocaleHelper.WORLD_NOT_LOADED.sendLocale(this.acc.getSender(), replace);
            }
            catch (PlayerNotFound e) {
                e.getSender().sendMessage(e.getMessage());
            }
            catch (ActionNotPermitedException e) {
                e.sendMessage();
            }
            catch (Throwable t) {
                ACLogger.severe(this.acc.debug(), t);
                Utils.broadcastMessage("[AdminCmd] " + this.acc.debug());
            }
        }

        public String toString() {
            return "NormalCommand [acc=" + this.acc + "]";
        }
    }
}

