/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Listeners.Features;

import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;

public class ACNoDropListener
implements Listener {
    private final Map<Player, List<ItemStack>> itemsDrops = new HashMap<Player, List<ItemStack>>();
    private final Map<String, List<ItemStack>> itemsOfDeadDisconnected = new HashMap<String, List<ItemStack>>();

    @EventHandler(ignoreCancelled=true)
    public void onDrop(PlayerDropItemEvent event) {
        if (ACPlayer.getPlayer(event.getPlayer()).hasPower(Type.NO_DROP)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDeath(EntityDeathEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player p = (Player)event.getEntity();
        ACPlayer player = ACPlayer.getPlayer(p);
        if (!player.hasPower(Type.NO_DROP) && !PermissionManager.hasPerm((CommandSender)p, "admincmd.spec.noloss", false)) {
            return;
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack item : event.getDrops()) {
            items.add(item.clone());
            item.setAmount(0);
        }
        this.itemsDrops.put(p, items);
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        Player p = event.getPlayer();
        ACPlayer player = ACPlayer.getPlayer(p);
        if (!player.hasPower(Type.NO_DROP) && !PermissionManager.hasPerm((CommandSender)p, "admincmd.spec.noloss", false)) {
            this.itemsDrops.remove(p);
            return;
        }
        List<ItemStack> items = this.itemsDrops.get(p);
        if (items == null) {
            return;
        }
        p.getInventory().addItem(items.toArray(new ItemStack[items.size()]));
        this.itemsDrops.remove(p);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        List<ItemStack> itemStacks = this.itemsDrops.remove(player);
        if (itemStacks != null && player.isDead()) {
            this.itemsOfDeadDisconnected.put(player.getName(), itemStacks);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onJoin(PlayerJoinEvent event) {
        Player p = event.getPlayer();
        ACPlayer player = ACPlayer.getPlayer(p);
        String name = p.getName();
        if (!player.hasPower(Type.NO_DROP) && !PermissionManager.hasPerm((CommandSender)p, "admincmd.spec.noloss", false)) {
            this.itemsOfDeadDisconnected.remove(name);
            return;
        }
        List<ItemStack> itemStacks = this.itemsOfDeadDisconnected.remove(name);
        if (itemStacks == null) {
            return;
        }
        this.itemsDrops.put(p, itemStacks);
    }
}

