/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Listeners.Features;

import be.Balor.Manager.Exceptions.WorldNotLoaded;
import be.Balor.Tools.Type;
import be.Balor.World.ACWorld;
import java.util.List;
import org.bukkit.World;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class ACCreatureSpawnListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        ACWorld acWorld;
        LivingEntity e = event.getEntity();
        if (e instanceof HumanEntity) {
            return;
        }
        World world = e.getWorld();
        try {
            acWorld = ACWorld.getWorld(world.getName());
        }
        catch (WorldNotLoaded e2) {
            return;
        }
        List livEntities = world.getLivingEntities();
        Integer limit = acWorld.getInformation(Type.MOB_LIMIT.toString()).getInt(-1);
        if (limit != -1 && livEntities.size() - world.getPlayers().size() >= limit) {
            event.setCancelled(true);
        }
        if (!event.isCancelled()) {
            Class<?> entityClass = e.getClass();
            String entityName = entityClass.getSimpleName();
            limit = acWorld.getMobLimit(entityName);
            if (limit == -1) {
                return;
            }
            int count = world.getEntitiesByClass(entityClass).size();
            if (count >= limit) {
                event.setCancelled(true);
            }
        }
    }
}

