/*
 * Decompiled with CFR 0.152.
 */
package belgium.Balor.Workers;

import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import com.google.common.collect.MapMaker;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.dynmap.DynmapAPI;

public final class InvisibleWorker {
    protected static InvisibleWorker instance = null;
    private final ConcurrentMap<Player, Object> invisiblesPlayers = new MapMaker().makeMap();
    private static final Object EMPTY = new Object();
    public static DynmapAPI dynmapAPI;

    protected InvisibleWorker() {
    }

    public static InvisibleWorker getInstance() {
        if (instance == null) {
            instance = new InvisibleWorker();
        }
        return instance;
    }

    public static InvisibleWorker createInstance() {
        if (instance == null) {
            instance = new InvisibleWorker();
        }
        return instance;
    }

    public static void killInstance() {
        instance = null;
    }

    public Collection<Player> getAllInvisiblePlayers() {
        return Collections.unmodifiableCollection(this.invisiblesPlayers.keySet());
    }

    public void onQuitEvent(Player toReappear) {
        this.invisiblesPlayers.remove(toReappear);
    }

    public void reappear(final Player toReappear) {
        this.invisiblesPlayers.remove(toReappear);
        if (dynmapAPI != null) {
            dynmapAPI.setPlayerVisiblity(toReappear, true);
        }
        ACPluginManager.getScheduler().scheduleAsyncDelayedTask((Plugin)ACPluginManager.getCorePlugin(), new Runnable(){

            @Override
            public void run() {
                for (Player p : Utils.getOnlinePlayers()) {
                    InvisibleWorker.this.uninvisible(toReappear, p);
                }
            }
        });
        if (ConfigEnum.FQINVISIBLE.getBoolean()) {
            Utils.broadcastFakeJoin(toReappear);
        }
    }

    private void invisible(final Player hide, final Player hideFrom) {
        if (hide == null) {
            return;
        }
        if (hideFrom == null) {
            return;
        }
        if (PermissionManager.hasPerm((CommandSender)hideFrom, "admincmd.invisible.cansee", false)) {
            return;
        }
        ACPluginManager.scheduleSyncTask(new Runnable(){

            @Override
            public void run() {
                hideFrom.hidePlayer(hide);
            }
        });
    }

    private void uninvisible(final Player unHide, final Player unHideFrom) {
        if (PermissionManager.hasPerm((CommandSender)unHideFrom, "admincmd.invisible.cansee", false)) {
            return;
        }
        ACPluginManager.scheduleSyncTask(new Runnable(){

            @Override
            public void run() {
                unHideFrom.showPlayer(unHide);
            }
        });
    }

    public boolean hasInvisiblePowers(Player player) {
        if (player == null) {
            return false;
        }
        return this.invisiblesPlayers.containsKey(player);
    }

    public void vanish(final Player toVanish, boolean onJoinEvent) {
        if (!this.invisiblesPlayers.containsKey(toVanish)) {
            this.invisiblesPlayers.put(toVanish, EMPTY);
            if (dynmapAPI != null) {
                dynmapAPI.setPlayerVisiblity(toVanish, false);
            }
            ACPluginManager.getScheduler().scheduleAsyncDelayedTask((Plugin)ACPluginManager.getCorePlugin(), new Runnable(){

                @Override
                public void run() {
                    for (Player p : Utils.getOnlinePlayers()) {
                        InvisibleWorker.this.invisible(toVanish, p);
                    }
                }
            });
        }
        if (!onJoinEvent && ConfigEnum.FQINVISIBLE.getBoolean()) {
            Utils.broadcastFakeQuit(toVanish);
        }
    }

    public int nbInvisibles() {
        return this.invisiblesPlayers.size();
    }

    public void makeInvisibleToPlayer(final Player newPlayer) {
        ACPluginManager.getScheduler().scheduleAsyncDelayedTask((Plugin)ACPluginManager.getCorePlugin(), new Runnable(){

            @Override
            public void run() {
                for (Player inv : InvisibleWorker.this.invisiblesPlayers.keySet()) {
                    InvisibleWorker.this.invisible(inv, newPlayer);
                }
            }
        });
    }
}

