/*
 * Decompiled with CFR 0.152.
 */
package belgium.Balor.Workers;

import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import belgium.Balor.Workers.InvisibleWorker;
import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class AFKWorker {
    private int afkTime = 60000;
    private int kickTime = 180000;
    private final ConcurrentMap<Player, Long> playerTimeStamp = new MapMaker().weakKeys().makeMap();
    private final ConcurrentMap<Player, Object> playersAfk = new MapMaker().weakKeys().makeMap();
    private final AfkChecker afkChecker = new AfkChecker();
    private final KickChecker kickChecker = new KickChecker();
    private static AFKWorker instance = new AFKWorker();

    private AFKWorker() {
    }

    public static AFKWorker getInstance() {
        return instance;
    }

    public static AFKWorker createInstance() {
        if (instance == null) {
            instance = new AFKWorker();
        }
        return instance;
    }

    public static void killInstance() {
        instance = null;
    }

    public AfkChecker getAfkChecker() {
        return this.afkChecker;
    }

    public KickChecker getKickChecker() {
        return this.kickChecker;
    }

    public void setAfkTime(int afkTime) {
        if (afkTime > 0) {
            this.afkTime = afkTime * 1000;
        }
    }

    public void setKickTime(int kickTime) {
        if (this.afkTime > 0) {
            this.kickTime = kickTime * 1000 * 60;
        }
    }

    public int nbAfk() {
        return this.playersAfk.size();
    }

    public void updateTimeStamp(Player player) {
        this.playerTimeStamp.put(player, System.currentTimeMillis());
    }

    public void removePlayer(Player player) {
        this.playersAfk.remove(player);
        this.playerTimeStamp.remove(player);
    }

    public void setAfk(Player p) {
        this.setAfk(p, null);
    }

    public void setAfk(Player p, String msg) {
        if (!InvisibleWorker.getInstance().hasInvisiblePowers(p) && !ACPlayer.getPlayer(p).hasPower(Type.FAKEQUIT)) {
            String afkString = Utils.I18n("afk", "player", Utils.getPlayerName(p, null));
            if (afkString != null) {
                afkString = afkString + (msg != null ? " : " + ChatColor.GOLD + msg : "");
            }
            Utils.broadcastMessage(afkString);
        }
        if (msg == null || msg != null && msg.isEmpty()) {
            this.playersAfk.put(p, System.currentTimeMillis());
        } else {
            this.playersAfk.put(p, msg);
        }
        p.setSleepingIgnored(true);
    }

    public void sendAfkMessage(CommandSender sender, Player buddy) {
        if (InvisibleWorker.getInstance().hasInvisiblePowers(buddy) || ACPlayer.getPlayer(buddy.getName()).hasPower(Type.FAKEQUIT)) {
            return;
        }
        Object obj = this.playersAfk.get(buddy);
        if (obj != null) {
            Utils.sI18n(sender, "noteAfk", "player", Utils.getPlayerName(buddy, sender));
            if (obj instanceof String) {
                sender.sendMessage((String)obj);
            } else if (obj instanceof Long) {
                Long[] time = Utils.getElapsedTime((Long)obj);
                Utils.sI18n(sender, "idleTime", "mins", time[2].toString());
            }
        }
    }

    public void setOnline(Player p) {
        String online;
        if (!InvisibleWorker.getInstance().hasInvisiblePowers(p) && !ACPlayer.getPlayer(p.getName()).hasPower(Type.FAKEQUIT) && (online = Utils.I18n("online", "player", Utils.getPlayerName(p, null))) != null) {
            Utils.broadcastMessage(online);
        }
        p.setSleepingIgnored(false);
        this.playersAfk.remove(p);
    }

    public boolean isAfk(Player p) {
        return this.playersAfk.containsKey(p);
    }

    private class KickChecker
    implements Runnable {
        private KickChecker() {
        }

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            for (final Player p : AFKWorker.this.playersAfk.keySet()) {
                Long timeStamp = (Long)AFKWorker.this.playerTimeStamp.get(p);
                if (timeStamp == null || now - timeStamp < (long)AFKWorker.this.kickTime || PermissionManager.hasPerm((CommandSender)p, "admincmd.player.noafkkick")) continue;
                ACPluginManager.scheduleSyncTask(new Runnable(){

                    @Override
                    public void run() {
                        p.kickPlayer(Utils.I18n("afkKick"));
                        AFKWorker.this.playersAfk.remove(p);
                        AFKWorker.this.playerTimeStamp.remove(p);
                    }
                });
            }
        }
    }

    private class AfkChecker
    implements Runnable {
        private AfkChecker() {
        }

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            for (Player p : Utils.getOnlinePlayers()) {
                Long timeStamp = (Long)AFKWorker.this.playerTimeStamp.get(p);
                if (timeStamp == null || AFKWorker.this.playersAfk.containsKey(p) || now - timeStamp < (long)AFKWorker.this.afkTime) continue;
                AFKWorker.this.setAfk(p);
            }
        }
    }
}

