/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.World;

import be.Balor.Manager.Exceptions.WorldNotLoaded;
import be.Balor.Tools.Configuration.ExConfigurationSection;
import be.Balor.Tools.Configuration.File.ExtendedConfiguration;
import be.Balor.Tools.Debug.ACLogger;
import be.Balor.Tools.Files.ObjectContainer;
import be.Balor.Tools.Help.String.Str;
import be.Balor.Tools.Warp;
import be.Balor.World.ACWorld;
import be.Balor.World.SimpleLocation;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.bukkit.Difficulty;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;

public class FileWorld
extends ACWorld {
    private final ExtendedConfiguration datas;
    private final ConfigurationSection warps;
    private final ExConfigurationSection informations;
    private final ExConfigurationSection mobLimits;

    public FileWorld(World world, String directory) {
        super(world);
        File wFile = new File(directory, world.getName() + ".yml");
        try {
            Files.createParentDirs((File)wFile);
        }
        catch (IOException e) {
            // empty catch block
        }
        this.datas = ExtendedConfiguration.loadConfiguration(wFile);
        this.warps = this.datas.addSection("warps");
        this.informations = this.datas.addSection("informations");
        this.mobLimits = this.informations.addSection("mobLimits");
        this.forceSave();
    }

    @Override
    public void setSpawn(Location loc) {
        this.datas.set("spawn", new SimpleLocation(loc));
        this.writeFile();
    }

    @Override
    public Location getSpawn() throws WorldNotLoaded {
        Object spawn = this.datas.get("spawn");
        if (spawn == null) {
            return this.handler.getSpawnLocation();
        }
        if (spawn instanceof SimpleLocation) {
            return ((SimpleLocation)spawn).getLocation();
        }
        return this.handler.getSpawnLocation();
    }

    @Override
    public Difficulty getDifficulty() throws WorldNotLoaded {
        Difficulty dif = (Difficulty)this.informations.get("difficulty");
        if (dif == null) {
            return this.handler.getDifficulty();
        }
        return dif;
    }

    @Override
    public void setDifficulty(final Difficulty dif) {
        ACPluginManager.scheduleSyncTask(new Runnable(){

            @Override
            public void run() {
                FileWorld.this.handler.setDifficulty(dif);
            }
        });
        this.informations.set("difficulty", dif);
    }

    @Override
    public void addWarp(String name, Location loc) {
        this.warps.set(name, (Object)new SimpleLocation(loc));
        this.writeFile();
    }

    @Override
    public Warp getWarp(String name) throws WorldNotLoaded, IllegalArgumentException {
        if (name == null || name != null && name.isEmpty()) {
            throw new IllegalArgumentException("Name can't be null or Empty");
        }
        Object warp = this.warps.get(name);
        String warpName = name;
        if (warp == null) {
            warpName = Str.matchString(this.warps.getKeys(false), name);
            if (warpName == null) {
                return null;
            }
            warp = this.warps.get(warpName);
        }
        return new Warp(warpName, ((SimpleLocation)warp).getLocation());
    }

    @Override
    public Set<String> getWarpList() {
        return this.warps.getKeys(false);
    }

    @Override
    public void removeWarp(String name) {
        this.warps.set(name, null);
        this.writeFile();
    }

    @Override
    public void setInformation(String info, Object value) {
        this.informations.set(info, value);
        this.writeFile();
    }

    @Override
    public void removeInformation(String info) {
        this.informations.set(info, null);
        this.writeFile();
    }

    @Override
    public ObjectContainer getInformation(String info) {
        return new ObjectContainer(this.informations.get(info));
    }

    private void writeFile() {
        this.forceSave();
    }

    @Override
    void forceSave() {
        try {
            this.datas.save();
        }
        catch (IOException e) {
            ACLogger.severe("Problem when saving the World File of " + this.getName(), e);
        }
    }

    @Override
    public Map<String, String> getInformations() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry entry : this.informations.getValues(false).entrySet()) {
            result.put((String)entry.getKey(), entry.getValue().toString());
        }
        for (Map.Entry entry : this.mobLimits.getValues(false).entrySet()) {
            result.put("Limit on " + (String)entry.getKey(), entry.getValue().toString());
        }
        return result;
    }

    @Override
    public void setMobLimit(String mob, int limit) {
        this.mobLimits.set(mob, limit);
        this.writeFile();
    }

    @Override
    public boolean removeMobLimit(String mob) {
        if (this.mobLimits.isSet(mob)) {
            this.mobLimits.remove(mob);
            this.writeFile();
            return true;
        }
        return false;
    }

    @Override
    public int getMobLimit(String mob) {
        return this.mobLimits.getInt(mob, -1);
    }

    @Override
    public Set<String> getMobLimitList() {
        return this.mobLimits.getKeys(false);
    }
}

