/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.World;

import be.Balor.Manager.Exceptions.WorldNotLoaded;
import be.Balor.Tools.Files.ObjectContainer;
import be.Balor.Tools.Warp;
import be.Balor.World.WorldManager;
import java.util.Map;
import java.util.Set;
import org.bukkit.Difficulty;
import org.bukkit.Location;
import org.bukkit.World;

public abstract class ACWorld {
    private final String name;
    protected final World handler;
    private final int hashCode;

    public ACWorld(World world) {
        int prime = 37;
        int result = 5;
        this.handler = world;
        this.name = world.getName();
        result = 37 * result + (this.handler == null ? 0 : this.handler.hashCode());
        this.hashCode = result = 37 * result + (this.name == null ? 0 : this.name.hashCode());
    }

    public World getHandler() {
        return this.handler;
    }

    public String getName() {
        return this.name;
    }

    public static ACWorld getWorld(String name) throws WorldNotLoaded {
        return WorldManager.getInstance().demandACWorld(name);
    }

    public abstract void setSpawn(Location var1);

    public abstract Location getSpawn();

    public abstract Difficulty getDifficulty() throws WorldNotLoaded;

    public abstract void setDifficulty(Difficulty var1);

    public abstract void addWarp(String var1, Location var2);

    public abstract Warp getWarp(String var1) throws WorldNotLoaded, IllegalArgumentException;

    public abstract Set<String> getWarpList();

    public abstract void removeWarp(String var1);

    public abstract void setInformation(String var1, Object var2);

    public abstract void removeInformation(String var1);

    public abstract ObjectContainer getInformation(String var1);

    public abstract Map<String, String> getInformations();

    abstract void forceSave();

    public abstract void setMobLimit(String var1, int var2);

    public abstract boolean removeMobLimit(String var1);

    public abstract int getMobLimit(String var1);

    public abstract Set<String> getMobLimitList();

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ACWorld)) {
            return false;
        }
        ACWorld other = (ACWorld)obj;
        if (this.handler == null ? other.handler != null : !this.handler.equals(other.handler)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

