/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools;

import be.Balor.Listeners.Events.ACTeleportEvent;
import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.LocaleManager;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Player.ACPlayer;
import be.Balor.Player.EmptyPlayer;
import be.Balor.Player.PlayerManager;
import be.Balor.Tools.Blocks.BlockRemanence;
import be.Balor.Tools.Blocks.IBlockRemanenceFactory;
import be.Balor.Tools.Blocks.LogBlockRemanenceFactory;
import be.Balor.Tools.Debug.DebugLog;
import be.Balor.Tools.Exceptions.InvalidInputException;
import be.Balor.Tools.Home;
import be.Balor.Tools.MaterialContainer;
import be.Balor.Tools.PlayerComparator;
import be.Balor.Tools.SimplifiedLocation;
import be.Balor.Tools.SynchronizedStack;
import be.Balor.Tools.Threads.CheckingBlockTask;
import be.Balor.Tools.Threads.ReplaceBlockTask;
import be.Balor.Tools.Threads.SetTimeTask;
import be.Balor.Tools.Threads.TeleportTask;
import be.Balor.Tools.TpRequest;
import be.Balor.Tools.Type;
import be.Balor.World.ACWorld;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import be.Balor.bukkit.AdminCmd.LocaleHelper;
import belgium.Balor.Workers.AFKWorker;
import belgium.Balor.Workers.InvisibleWorker;
import com.google.common.base.Joiner;
import com.miraclem4n.mchat.api.Reader;
import de.diddiz.LogBlock.Consumer;
import in.mDev.MiracleM4n.mChatSuite.types.EventType;
import info.somethingodd.OddItem.OddItem;
import info.somethingodd.OddItem.OddItemBase;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet201PlayerInfo;
import net.minecraft.server.WorldServer;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public final class Utils {
    public static OddItemBase oddItem = null;
    public static Consumer logBlock = null;
    public static boolean mChatPresent = false;
    public static boolean signExtention = false;
    public static final long secondInMillis = 1000L;
    public static final long minuteInMillis = 60000L;
    public static final long hourInMillis = 3600000L;
    public static final long dayInMillis = 86400000L;
    public static final int secInTick = 20;
    private static final Character delimiter = Character.valueOf('&');
    public static final Pattern regexColorParser = Pattern.compile(delimiter + "[A-Fa-f]|" + delimiter + "1[0-5]|" + delimiter + "[0-9]");
    public static final Pattern REGEX_IP_V4 = Pattern.compile("\\b(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\\b");
    public static final Pattern REGEX_INACCURATE_IP_V4 = Pattern.compile("\\b([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})\\b");
    public static final int MAX_BLOCKS = 512;

    private Utils() {
    }

    public static void addLocale(String key, String value) {
        LocaleManager.getInstance().addLocale(key, value);
    }

    public static void addLocale(String key, String value, boolean override) {
        LocaleManager.getInstance().addLocale(key, value, true);
    }

    public static void addPlayerInOnlineList(Player player) {
        ((CraftServer)player.getServer()).getHandle().sendAll((Packet)new Packet201PlayerInfo(((CraftPlayer)player).getHandle().listName, true, 1000));
    }

    public static void addPlayerInOnlineList(Player toAdd, Player fromPlayer) {
        ((CraftPlayer)fromPlayer).getHandle().netServerHandler.sendPacket((Packet)new Packet201PlayerInfo(((CraftPlayer)toAdd).getHandle().listName, true, 1000));
    }

    public static <T> T[] Arrays_copyOfRange(T[] original, int start, int end) {
        if (original.length >= start && 0 <= start) {
            if (start <= end) {
                int length = end - start;
                int copyLength = Math.min(length, original.length - start);
                Object[] copy = (Object[])Array.newInstance(original.getClass().getComponentType(), length);
                System.arraycopy(original, start, copy, 0, copyLength);
                return copy;
            }
            throw new IllegalArgumentException();
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public static void broadcastFakeJoin(Player player) {
        if (mChatPresent) {
            Utils.broadcastMessage(Utils.getPlayerName(player, null, true) + " " + Reader.getEventMessage((EventType)EventType.JOIN));
        } else {
            Utils.broadcastMessage(Utils.I18n("joinMessage", "name", Utils.getPlayerName(player, null, true)));
        }
    }

    public static void broadcastFakeQuit(Player player) {
        if (mChatPresent) {
            Utils.broadcastMessage(Utils.getPlayerName(player, null, true) + " " + Reader.getEventMessage((EventType)EventType.QUIT));
        } else {
            Utils.broadcastMessage(Utils.I18n("quitMessage", "name", Utils.getPlayerName(player, null, true)));
        }
    }

    public static void broadcastMessage(String message) {
        for (Player p : Utils.getOnlinePlayers()) {
            p.sendMessage(message);
        }
    }

    public static boolean checkImmunity(CommandSender sender, CommandArgs args, int index) {
        Player target = sender.getServer().getPlayer(args.getString(index));
        if (target != null) {
            if (Utils.checkImmunity(sender, target)) {
                return true;
            }
            Utils.sI18n(sender, "insufficientLvl");
            return false;
        }
        if (Utils.preImmunityCheck(sender, target)) {
            return true;
        }
        Player player = (Player)sender;
        int pLvl = ACHelper.getInstance().getLimit(player, Type.Limit.IMMUNITY, "defaultImmunityLvl");
        int tLvl = ACPlayer.getPlayer(args.getString(index)).getInformation("immunityLvl").getInt(0);
        return Utils.checkLvl(player, pLvl, tLvl);
    }

    public static boolean checkImmunity(CommandSender sender, Player target) {
        if (Utils.preImmunityCheck(sender, target)) {
            return true;
        }
        Player player = (Player)sender;
        int pLvl = ACHelper.getInstance().getLimit(player, Type.Limit.IMMUNITY, "defaultImmunityLvl");
        int tLvl = ACHelper.getInstance().getLimit(target, Type.Limit.IMMUNITY, "defaultImmunityLvl");
        return Utils.checkLvl(player, pLvl, tLvl);
    }

    public static boolean checkImmunity(CommandSender sender, ACPlayer target) {
        if (Utils.preImmunityCheck(sender, target)) {
            return true;
        }
        Player player = (Player)sender;
        int pLvl = ACHelper.getInstance().getLimit(player, Type.Limit.IMMUNITY, "defaultImmunityLvl");
        int tLvl = 0;
        tLvl = target.isOnline() ? ACHelper.getInstance().getLimit(target.getHandler(), Type.Limit.IMMUNITY, "defaultImmunityLvl") : target.getInformation("immunityLvl").getInt(0);
        return Utils.checkLvl(player, pLvl, tLvl);
    }

    private static boolean checkLvl(Player player, int pLvl, int tLvl) {
        if (PermissionManager.hasPerm((CommandSender)player, "admincmd.immunityLvl.samelvl", false) && pLvl != tLvl) {
            return false;
        }
        return pLvl >= tLvl;
    }

    private static boolean preImmunityCheck(CommandSender sender, Object target) {
        if (!ConfigEnum.IMMUNITY.getBoolean()) {
            return true;
        }
        if (!Utils.isPlayer(sender, false)) {
            return true;
        }
        return target == null;
    }

    public static MaterialContainer checkMaterial(String mat) throws InvalidInputException {
        MaterialContainer mc = new MaterialContainer();
        try {
            ItemStack is;
            if (oddItem != null && (is = OddItem.getItemStack((String)mat)) != null) {
                return new MaterialContainer(is);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String[] info = new String[2];
        if (mat.contains(":")) {
            info = mat.split(":");
            if (info.length < 2) {
                throw new InvalidInputException(mat);
            }
            mc = new MaterialContainer(info[0], info[1]);
        } else {
            info[0] = mat;
            info[1] = "0";
            mc = ACHelper.getInstance().getAlias(info[0]);
            if (mc == null) {
                mc = new MaterialContainer(info[0], info[1]);
            }
        }
        return mc;
    }

    public static String colorParser(String toParse) {
        String ResultString = null;
        try {
            Matcher regexMatcher = regexColorParser.matcher(toParse);
            String result = toParse;
            while (regexMatcher.find()) {
                ResultString = regexMatcher.group();
                int colorint = Integer.parseInt(ResultString.substring(1, 2), 16);
                if (ResultString.length() > 1 && colorint == 1 && ResultString.substring(2).matches("[012345]")) {
                    colorint = colorint * 10 + Integer.parseInt(ResultString.substring(2));
                }
                result = regexMatcher.replaceFirst(ChatColor.getByChar((String)Integer.toHexString(colorint)).toString());
                regexMatcher = regexColorParser.matcher(result);
            }
            return result;
        }
        catch (Exception ex) {
            return toParse;
        }
    }

    private static Stack<BlockRemanence> drainFluid(String playername, Block block, int radius) {
        Stack<BlockRemanence> blocks = new Stack<BlockRemanence>();
        Stack<SimplifiedLocation> processQueue = new Stack<SimplifiedLocation>();
        BlockRemanence current = null;
        World w = block.getWorld();
        Location start = block.getLocation();
        HashSet<SimplifiedLocation> visited = new HashSet<SimplifiedLocation>();
        Stack<BlockRemanence> blocksCache = new Stack<BlockRemanence>();
        for (int x = block.getX() - 2; x <= block.getX() + 2; ++x) {
            for (int z = block.getZ() - 2; z <= block.getZ() + 2; ++z) {
                for (int y = block.getY() - 2; y <= block.getY() + 2; ++y) {
                    SimplifiedLocation newPos = new SimplifiedLocation(w, x, y, z);
                    if (!Utils.isFluid(newPos) || visited.contains((Object)newPos)) continue;
                    visited.add(newPos);
                    processQueue.push(newPos);
                    current = IBlockRemanenceFactory.FACTORY.createBlockRemanence(newPos);
                    blocks.push(current);
                    blocksCache.push(current);
                    if (blocksCache.size() != 512) continue;
                    ACPluginManager.getScheduler().scheduleSyncDelayedTask((Plugin)ACHelper.getInstance().getCoreInstance(), (Runnable)new ReplaceBlockTask(blocksCache));
                }
            }
        }
        while (!processQueue.isEmpty()) {
            SimplifiedLocation loc = (SimplifiedLocation)((Object)processQueue.pop());
            for (int y = loc.getBlockY() - 1; y <= loc.getBlockY() + 1; ++y) {
                for (int x = loc.getBlockX() - 1; x <= loc.getBlockX() + 1; ++x) {
                    for (int z = loc.getBlockZ() - 1; z <= loc.getBlockZ() + 1; ++z) {
                        SimplifiedLocation newPos = new SimplifiedLocation(w, x, y, z);
                        if (visited.contains((Object)newPos) || !Utils.isFluid(newPos) || !(start.distance((Location)newPos) < (double)radius)) continue;
                        processQueue.push(newPos);
                        current = IBlockRemanenceFactory.FACTORY.createBlockRemanence(newPos);
                        blocks.push(current);
                        blocksCache.push(current);
                        if (blocksCache.size() == 512) {
                            ACPluginManager.getScheduler().scheduleSyncDelayedTask((Plugin)ACHelper.getInstance().getCoreInstance(), (Runnable)new ReplaceBlockTask(blocksCache));
                        }
                        visited.add(newPos);
                    }
                }
            }
        }
        ACPluginManager.getScheduler().scheduleSyncDelayedTask((Plugin)ACHelper.getInstance().getCoreInstance(), (Runnable)new ReplaceBlockTask(blocksCache));
        return blocks;
    }

    public static ACPlayer getACPlayer(CommandSender sender, CommandArgs args, String permNode) throws PlayerNotFound, ActionNotPermitedException {
        ACPlayer actarget;
        Player target = Utils.getUser(sender, args, permNode, 0, false);
        if (target == null) {
            if (args.length == 0) {
                sender.sendMessage("You must type the player name");
                return null;
            }
            actarget = ACPlayer.getPlayer(args.getString(0));
            if (actarget instanceof EmptyPlayer) {
                Utils.sI18n(sender, "playerNotFound", "player", actarget.getName());
                return null;
            }
            if (!Utils.checkImmunity(sender, args, 0)) {
                Utils.sI18n(sender, "insufficientLvl");
                return null;
            }
        } else {
            if (!Utils.checkImmunity(sender, target)) {
                return null;
            }
            actarget = ACPlayer.getPlayer(target);
        }
        return actarget;
    }

    public static double getDistanceSquared(Player player1, Player player2) {
        if (!player1.getWorld().getName().equals(player2.getWorld().getName())) {
            return Double.MAX_VALUE;
        }
        Location loc1 = player1.getLocation();
        Location loc2 = player2.getLocation();
        return Math.pow(loc1.getX() - loc2.getX(), 2.0) + Math.pow(loc1.getZ() - loc2.getZ(), 2.0);
    }

    public static Long[] getElapsedTime(long start) {
        return Utils.transformToElapsedTime(System.currentTimeMillis() - start);
    }

    public static Home getHome(CommandSender sender, String toParse) {
        Home result = new Home();
        if (toParse != null && toParse.contains(":")) {
            Player p;
            try {
                String[] split = toParse.split(":");
                result.player = split[0];
                result.home = split[1];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
            if (Utils.isPlayer(sender, false) && !(p = (Player)sender).getName().equals(result.player) && !PermissionManager.hasPerm((CommandSender)p, "admincmd.admin.home")) {
                return null;
            }
            return result;
        }
        if (!Utils.isPlayer(sender)) {
            return null;
        }
        Player p = (Player)sender;
        result.player = p.getName();
        result.home = toParse != null ? toParse : p.getWorld().getName();
        return result;
    }

    public static List<Player> getOnlinePlayers() {
        return PlayerManager.getInstance().getOnlinePlayers();
    }

    public static Player getPlayer(String name) {
        Player[] players = ACPluginManager.getServer().getOnlinePlayers();
        Player found = null;
        String lowerName = name.toLowerCase();
        int delta = Integer.MAX_VALUE;
        for (Player player : players) {
            if (!player.getName().toLowerCase().startsWith(lowerName)) continue;
            int curDelta = player.getName().length() - lowerName.length();
            if (curDelta < delta) {
                found = player;
                delta = curDelta;
            } else {
                curDelta = player.getDisplayName().length() - lowerName.length();
                if (curDelta < delta) {
                    found = player;
                    delta = curDelta;
                }
            }
            if (curDelta == 0) break;
        }
        return found;
    }

    public static String getPlayerName(Player player) {
        return Utils.getPlayerName(player, null);
    }

    public static String getPlayerName(Player player, CommandSender sender, boolean withPrefix) {
        return Utils.getPlayerName(player, sender);
    }

    public static String getPlayerName(Player player, CommandSender sender) {
        assert (player != null);
        if (ConfigEnum.USE_PREFIX.getBoolean()) {
            String prefix = Utils.colorParser(Utils.getPrefix(player, sender));
            String suffix = Utils.colorParser(PermissionManager.getSuffix(player));
            if (ConfigEnum.DNAME.getBoolean()) {
                return prefix + player.getDisplayName() + suffix + ChatColor.YELLOW;
            }
            return prefix + player.getName() + suffix + ChatColor.YELLOW;
        }
        if (ConfigEnum.DNAME.getBoolean()) {
            return player.getDisplayName();
        }
        return player.getName();
    }

    private static String getPrefix(Player player, CommandSender sender) {
        boolean isInv = false;
        String prefixstring = "";
        String statusPrefix = "";
        if (sender != null) {
            boolean bl = isInv = InvisibleWorker.getInstance().hasInvisiblePowers(player) && PermissionManager.hasPerm(sender, "admincmd.invisible.cansee", false);
        }
        if (isInv) {
            statusPrefix = Utils.I18n("invTitle");
        }
        if (AFKWorker.getInstance().isAfk(player)) {
            statusPrefix = Utils.I18n("afkTitle") + statusPrefix;
        }
        prefixstring = PermissionManager.getPrefix(player);
        String result = statusPrefix;
        if (prefixstring != null && prefixstring.length() > 1) {
            result = result + prefixstring;
        }
        return Utils.colorParser(result);
    }

    public static Date getServerRealTime(String gmt) {
        TimeZone tz = TimeZone.getTimeZone(gmt);
        Calendar cal = Calendar.getInstance(tz);
        cal.setTime(new Date());
        Date serverTime = cal.getTime();
        return serverTime;
    }

    public static Player getUser(CommandSender sender, CommandArgs args, String permNode) throws PlayerNotFound, ActionNotPermitedException {
        return Utils.getUser(sender, args, permNode, 0, true);
    }

    public static Player getUser(CommandSender sender, CommandArgs args, String permNode, int index, boolean errorMsg) throws PlayerNotFound, ActionNotPermitedException {
        Player target = null;
        if (args.length >= index + 1) {
            target = Utils.getPlayer(args.getString(index));
            if (target != null) {
                if (target.equals(sender)) {
                    return target;
                }
                if (PermissionManager.hasPerm(sender, permNode + ".other", false)) {
                    if (Utils.checkImmunity(sender, target)) {
                        return target;
                    }
                    throw new PlayerNotFound(Utils.I18n("insufficientLvl"), sender);
                }
                throw new ActionNotPermitedException(sender, permNode + ".other");
            }
        } else if (Utils.isPlayer(sender, false)) {
            target = (Player)sender;
        } else if (errorMsg) {
            sender.sendMessage("You must type the player name");
            return target;
        }
        if (target == null && errorMsg) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("player", args.getString(index));
            throw new PlayerNotFound(Utils.I18n("playerNotFound", replace), sender);
        }
        return target;
    }

    public static Player getUserParam(CommandSender sender, CommandArgs args, String permNode) throws PlayerNotFound, ActionNotPermitedException {
        return Utils.getUserParam(sender, args, permNode, true);
    }

    public static Player getUserParam(CommandSender sender, CommandArgs args, String permNode, boolean errorMsg) throws PlayerNotFound, ActionNotPermitedException {
        Player target = null;
        String playerName = args.getValueFlag('P');
        if (playerName != null) {
            target = Utils.getPlayer(playerName);
            if (target != null) {
                if (target.equals(sender)) {
                    return target;
                }
                if (PermissionManager.hasPerm(sender, permNode + ".other", false)) {
                    if (Utils.checkImmunity(sender, target)) {
                        return target;
                    }
                    throw new PlayerNotFound(Utils.I18n("insufficientLvl"), sender);
                }
                throw new ActionNotPermitedException(sender, permNode + ".other");
            }
        } else if (Utils.isPlayer(sender, false)) {
            target = (Player)sender;
        } else if (errorMsg) {
            sender.sendMessage("You must type the player name");
            return target;
        }
        if (target == null && errorMsg) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("player", playerName);
            throw new PlayerNotFound(Utils.I18n("playerNotFound", replace), sender);
        }
        return target;
    }

    public static String I18n(String key) {
        return Utils.I18n(key, null);
    }

    public static String I18n(String key, Map<String, String> replace) {
        return LocaleManager.getInstance().get(key, replace);
    }

    public static String I18n(String key, String alias, String toReplace) {
        return LocaleManager.getInstance().get(key, alias, toReplace);
    }

    public static String I18n(LocaleHelper key) {
        return Utils.I18n(key.getKey(), null);
    }

    public static String I18n(LocaleHelper key, Map<String, String> replace) {
        return LocaleManager.getInstance().get(key.getKey(), replace);
    }

    public static String I18n(LocaleHelper key, String alias, String toReplace) {
        return LocaleManager.getInstance().get(key.getKey(), alias, toReplace);
    }

    private static boolean isFluid(Location loc) {
        Block b = loc.getWorld().getBlockAt(loc);
        if (b == null) {
            return false;
        }
        return b.getType() == Material.WATER || b.getType() == Material.STATIONARY_WATER || b.getType() == Material.LAVA || b.getType() == Material.STATIONARY_LAVA;
    }

    public static boolean isPlayer(CommandSender sender) {
        return Utils.isPlayer(sender, true);
    }

    public static boolean isPlayer(CommandSender sender, boolean msg) {
        if (sender instanceof Player) {
            return true;
        }
        if (msg) {
            Utils.sI18n(sender, "mustBePlayer");
        }
        return false;
    }

    public static void removePlayerFromOnlineList(Player player) {
        ((CraftServer)player.getServer()).getHandle().sendAll((Packet)new Packet201PlayerInfo(((CraftPlayer)player).getHandle().listName, false, 9999));
    }

    public static void removePlayerFromOnlineList(Player toRemove, Player fromPlayer) {
        if (toRemove == null || fromPlayer == null) {
            return;
        }
        ((CraftPlayer)fromPlayer).getHandle().netServerHandler.sendPacket((Packet)new Packet201PlayerInfo(((CraftPlayer)toRemove).getHandle().listName, false, 9999));
    }

    public static Integer replaceBlockByAir(CommandSender sender, CommandArgs args, List<Material> mat, int defaultRadius) {
        if (Utils.isPlayer(sender)) {
            int radius;
            block7: {
                radius = defaultRadius;
                if (args.length >= 1) {
                    try {
                        radius = args.getInt(0);
                    }
                    catch (NumberFormatException e) {
                        if (args.length < 2) break block7;
                        try {
                            radius = args.getInt(1);
                        }
                        catch (NumberFormatException e2) {
                            // empty catch block
                        }
                    }
                }
            }
            String playername = ((Player)sender).getName();
            IBlockRemanenceFactory.FACTORY.setPlayerName(playername);
            Block block = ((Player)sender).getLocation().getBlock();
            Stack<BlockRemanence> blocks = mat.contains(Material.LAVA) || mat.contains(Material.WATER) ? Utils.drainFluid(playername, block, radius) : Utils.replaceInCuboid(playername, mat, block, radius);
            if (!blocks.isEmpty()) {
                ACHelper.getInstance().addInUndoQueue(playername, blocks);
            }
            return blocks.size();
        }
        return null;
    }

    public static String replaceDateAndTimeFormat(Date date) {
        String timeFormatted = "";
        String format = ConfigEnum.DT_FORMAT.getString();
        SimpleDateFormat formater = new SimpleDateFormat(format);
        Date serverTime = date;
        timeFormatted = formater.format(serverTime);
        return timeFormatted;
    }

    public static String replaceDateAndTimeFormat(ACPlayer player, Type.Whois type) {
        String format = ConfigEnum.DT_FORMAT.getString();
        SimpleDateFormat formater = new SimpleDateFormat(format);
        String lastlogin = "";
        lastlogin = formater.format(new Date(player.getInformation(type.getVal()).getLong(1L)));
        if (lastlogin == formater.format(new Date(1L))) {
            return null;
        }
        return lastlogin;
    }

    private static Stack<BlockRemanence> replaceInCuboid(String playername, List<Material> mat, Block block, int radius) {
        SynchronizedStack<BlockRemanence> blocks = new SynchronizedStack<BlockRemanence>();
        SynchronizedStack<BlockRemanence> blocksCache = new SynchronizedStack<BlockRemanence>();
        int limitX = block.getX() + radius;
        int limitY = block.getY() + radius;
        int limitZ = block.getZ() + radius;
        BlockRemanence br = null;
        Semaphore sema = new Semaphore(0, true);
        ArrayList<SimplifiedLocation> okBlocks = new ArrayList<SimplifiedLocation>(50);
        ACPluginManager.scheduleSyncTask(new CheckingBlockTask(sema, okBlocks, block, radius, limitY, limitX, limitZ, mat));
        try {
            sema.acquire();
        }
        catch (InterruptedException e) {
            DebugLog.INSTANCE.log(Level.SEVERE, "Problem with acquiring the semaphore", e);
        }
        for (SimplifiedLocation loc : okBlocks) {
            br = IBlockRemanenceFactory.FACTORY.createBlockRemanence(loc);
            ((Stack)blocks).push(br);
            ((Stack)blocksCache).push(br);
            if (blocksCache.size() != 512) continue;
            ACPluginManager.getScheduler().scheduleSyncDelayedTask((Plugin)ACHelper.getInstance().getCoreInstance(), (Runnable)new ReplaceBlockTask(blocksCache), 1L);
        }
        ACPluginManager.getScheduler().scheduleSyncDelayedTask((Plugin)ACHelper.getInstance().getCoreInstance(), (Runnable)new ReplaceBlockTask(blocksCache), 1L);
        return blocks;
    }

    public static void sendMessage(CommandSender sender, CommandSender player, String key) {
        Utils.sendMessage(sender, player, key, null);
    }

    public static void sendMessage(CommandSender sender, CommandSender player, String key, Map<String, String> replace) {
        String msg = Utils.I18n(key, replace);
        if (msg != null && !msg.isEmpty()) {
            if (!sender.equals(player)) {
                player.sendMessage(msg);
            }
            sender.sendMessage(msg);
        }
    }

    public static void setLogBlock(Consumer logBlock) {
        Utils.logBlock = logBlock;
        IBlockRemanenceFactory.FACTORY = new LogBlockRemanenceFactory();
    }

    public static boolean setPlayerHealth(CommandSender sender, CommandArgs name, Type.Health toDo) throws PlayerNotFound, ActionNotPermitedException {
        Player target = Utils.getUser(sender, name, "admincmd.player." + (Object)((Object)toDo));
        if (target == null) {
            return false;
        }
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("player", Utils.getPlayerName(target));
        PluginManager pluginManager = ACPluginManager.getServer().getPluginManager();
        String newStateLocale = LocaleHelper.NEW_STATE.getLocale();
        String newStatePlayerLocale = LocaleHelper.NEW_STATE_PLAYER.getLocale(replace);
        switch (toDo) {
            case HEAL: {
                EntityRegainHealthEvent heal = new EntityRegainHealthEvent((Entity)target, 20, EntityRegainHealthEvent.RegainReason.CUSTOM);
                pluginManager.callEvent((Event)heal);
                if (heal.isCancelled()) break;
                target.setHealth(heal.getAmount());
                target.setFireTicks(0);
                String msg = newStateLocale + LocaleHelper.HEALED.getLocale();
                target.sendMessage(msg);
                if (target.equals(sender)) break;
                String newStateMsg = newStatePlayerLocale + LocaleHelper.HEALED.getLocale();
                sender.sendMessage(newStateMsg);
                break;
            }
            case FEED: {
                FoodLevelChangeEvent foodEvent = new FoodLevelChangeEvent((HumanEntity)target, 20);
                pluginManager.callEvent((Event)foodEvent);
                if (foodEvent.isCancelled()) break;
                target.setFoodLevel(foodEvent.getFoodLevel());
                String msg = newStateLocale + LocaleHelper.FEEDED.getLocale();
                target.sendMessage(msg);
                if (target.equals(sender)) break;
                String newStateMsg = newStatePlayerLocale + LocaleHelper.FEEDED.getLocale();
                sender.sendMessage(newStateMsg);
                break;
            }
            case KILL: {
                if (target.equals(sender)) {
                    EntityDamageEvent dmgEvent = new EntityDamageEvent((Entity)target, EntityDamageEvent.DamageCause.SUICIDE, Short.MAX_VALUE);
                    pluginManager.callEvent((Event)dmgEvent);
                    if (!dmgEvent.isCancelled()) {
                        target.damage(Short.MAX_VALUE);
                        LocaleHelper.SUICIDE.sendLocale((CommandSender)target);
                    }
                } else {
                    EntityDamageEvent dmgEvent = new EntityDamageEvent((Entity)target, EntityDamageEvent.DamageCause.CUSTOM, Short.MAX_VALUE);
                    pluginManager.callEvent((Event)dmgEvent);
                    if (!dmgEvent.isCancelled()) {
                        if (Utils.isPlayer(sender, false)) {
                            target.damage(dmgEvent.getDamage(), (Entity)((Player)sender));
                        } else {
                            target.damage(dmgEvent.getDamage());
                        }
                        String msg = newStateLocale + LocaleHelper.KILLED.getLocale();
                        target.sendMessage(msg);
                        String newStateMsg = newStatePlayerLocale + LocaleHelper.KILLED.getLocale();
                        sender.sendMessage(newStateMsg);
                    }
                }
                if (logBlock == null) break;
                logBlock.queueKill((Entity)(Utils.isPlayer(sender, false) ? (Player)sender : null), (Entity)target);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static void setTime(CommandSender sender, World w, String arg) {
        long curtime = w.getTime();
        long newtime = curtime - curtime % 24000L;
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("type", arg);
        replace.put("world", w.getName());
        if (ACWorld.getWorld(w.getName()).getInformation(Type.TIME_FREEZED.toString()).isNull()) {
            if (arg.equalsIgnoreCase("day")) {
                newtime += 0L;
            } else if (arg.equalsIgnoreCase("night")) {
                newtime += 14000L;
            } else if (arg.equalsIgnoreCase("dusk")) {
                newtime += 12500L;
            } else if (arg.equalsIgnoreCase("dawn")) {
                newtime += 23000L;
            } else if (arg.equalsIgnoreCase("pause")) {
                int taskId = ACPluginManager.getScheduler().scheduleSyncRepeatingTask((Plugin)ACHelper.getInstance().getCoreInstance(), (Runnable)new SetTimeTask(w), 0L, 5L);
                ACWorld.getWorld(w.getName()).setInformation(Type.TIME_FREEZED.toString(), taskId);
            } else {
                try {
                    newtime += (long)Integer.parseInt(arg);
                }
                catch (Exception e) {
                    Utils.sI18n(sender, "timeNotSet", replace);
                    return;
                }
            }
            Utils.sI18n(sender, "timeSet", replace);
        } else if (arg.equalsIgnoreCase("unpause")) {
            int removeTask = ACWorld.getWorld(w.getName()).getInformation(Type.TIME_FREEZED.toString()).getInt(-1);
            ACPluginManager.getScheduler().cancelTask(removeTask);
            ACWorld.getWorld(w.getName()).removeInformation(Type.TIME_FREEZED.toString());
            Utils.sI18n(sender, "timeSet", replace);
        } else {
            Utils.sI18n(sender, "timePaused", "world", w.getName());
        }
        ACPluginManager.scheduleSyncTask(new SetTimeTask(w, newtime));
    }

    public static void sI18n(CommandSender sender, String key) {
        Utils.sI18n(sender, key, null);
    }

    public static void sI18n(CommandSender sender, String key, Map<String, String> replace) {
        String locale = Utils.I18n(key, replace);
        if (locale != null && !locale.isEmpty()) {
            sender.sendMessage(locale);
        }
    }

    public static void sI18n(CommandSender sender, String key, String alias, String toReplace) {
        String locale = Utils.I18n(key, alias, toReplace);
        if (locale != null && !locale.isEmpty()) {
            sender.sendMessage(locale);
        }
    }

    public static void sI18n(CommandSender sender, LocaleHelper key) {
        Utils.sI18n(sender, key, null);
    }

    public static void sI18n(CommandSender sender, LocaleHelper key, Map<String, String> replace) {
        String locale = Utils.I18n(key, replace);
        if (locale != null && !locale.isEmpty()) {
            sender.sendMessage(locale);
        }
    }

    public static void sI18n(CommandSender sender, LocaleHelper key, String alias, String toReplace) {
        String locale = Utils.I18n(key, alias, toReplace);
        if (locale != null && !locale.isEmpty()) {
            sender.sendMessage(locale);
        }
    }

    public static void sParsedLocale(Player p, String locale) {
        HashMap<String, String> replace = new HashMap<String, String>();
        ACPlayer acPlayer = ACPlayer.getPlayer(p);
        long total = acPlayer.getCurrentPlayedTime();
        replace.putAll(Utils.playedTime(Utils.getPlayerName(p), total));
        replace.put("nb", String.valueOf(p.getServer().getOnlinePlayers().length - InvisibleWorker.getInstance().nbInvisibles()));
        Collection<String> list = Utils.getPlayerList((CommandSender)p);
        String connected = Joiner.on((String)", ").join(list);
        if (connected.length() >= 318) {
            String tmp = connected.substring(0, 318);
            String tmp2 = connected.substring(318, connected.length());
            connected = tmp + "//n" + tmp2;
        }
        replace.put("connected", connected);
        String serverTime = Utils.replaceDateAndTimeFormat(Utils.getServerRealTime("GMT" + ConfigEnum.DT_GMT.getString()));
        replace.put("time", serverTime);
        String date = Utils.replaceDateAndTimeFormat(acPlayer, Type.Whois.LOGIN);
        if (date == null) {
            replace.put("lastlogin", Utils.I18n("noLoginInformation"));
        } else {
            replace.put("lastlogin", date);
        }
        String motd = Utils.I18n(locale, replace).replace("\\n", "\n").replace("//n", "\n");
        if (motd != null) {
            for (String toSend : motd.split("\n")) {
                if (toSend.isEmpty()) continue;
                p.sendMessage(toSend);
            }
        }
    }

    public static boolean timeSet(CommandSender sender, String time) {
        return Utils.timeSet(sender, time, null);
    }

    public static boolean timeSet(CommandSender sender, String time, String world) {
        if (Utils.isPlayer(sender, false) && world == null) {
            Player p = (Player)sender;
            Utils.setTime(sender, p.getWorld(), time);
        } else if (world != null) {
            World w = sender.getServer().getWorld(world);
            if (w == null) {
                HashMap<String, String> replace = new HashMap<String, String>();
                replace.put("world", world);
                Utils.sI18n(sender, "worldNotFound", replace);
                return true;
            }
            Utils.setTime(sender, w, time);
        } else {
            for (World w : sender.getServer().getWorlds()) {
                Utils.setTime(sender, w, time);
            }
        }
        return true;
    }

    public static void tpP2P(CommandSender sender, String nFrom, String nTo, Type.Tp type) {
        boolean found = true;
        Player pFrom = ACPluginManager.getServer().getPlayer(nFrom);
        Player pTo = ACPluginManager.getServer().getPlayer(nTo);
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("player", nFrom);
        if (pFrom == null) {
            replace.put("player", nFrom);
            Utils.sI18n(sender, "playerNotFound", replace);
            found = false;
        }
        if (pTo == null) {
            replace.put("player", nTo);
            Utils.sI18n(sender, "playerNotFound", replace);
            found = false;
        }
        if (!found) {
            return;
        }
        if (!(ConfigEnum.TP_DIFF_WORLD.getBoolean() || pFrom.getWorld().equals(pTo.getWorld()) || PermissionManager.hasPerm(sender, "admincmd.tp.world." + pTo.getWorld().getName().replace(' ', '_'), false))) {
            replace.put("to", pTo.getName());
            Utils.sI18n(sender, "diffWorld", replace);
            return;
        }
        if (type.equals((Object)Type.Tp.TO) && !Utils.checkImmunity((CommandSender)pFrom, pTo)) {
            Utils.sI18n(sender, "insufficientLvl");
            return;
        }
        if (type.equals((Object)Type.Tp.HERE) && !Utils.checkImmunity((CommandSender)pTo, pFrom)) {
            Utils.sI18n(sender, "insufficientLvl");
            return;
        }
        if (type.equals((Object)Type.Tp.PLAYERS) && !Utils.checkImmunity(sender, pFrom) && !Utils.checkImmunity(sender, pTo)) {
            Utils.sI18n(sender, "insufficientLvl");
            return;
        }
        if ((type.equals((Object)Type.Tp.TO) || type.equals((Object)Type.Tp.PLAYERS)) && InvisibleWorker.getInstance().hasInvisiblePowers(pTo) && !PermissionManager.hasPerm((CommandSender)pFrom, "admincmd.invisible.cansee", false)) {
            replace.put("player", nTo);
            Utils.sI18n(sender, "playerNotFound", replace);
            return;
        }
        if ((type.equals((Object)Type.Tp.HERE) || type.equals((Object)Type.Tp.PLAYERS)) && InvisibleWorker.getInstance().hasInvisiblePowers(pFrom) && !PermissionManager.hasPerm((CommandSender)pTo, "admincmd.invisible.cansee", false)) {
            replace.put("player", nFrom);
            Utils.sI18n(sender, "playerNotFound", replace);
            return;
        }
        if (PermissionManager.hasPerm(sender, "admincmd.spec.notprequest", false)) {
            ACPluginManager.scheduleSyncTask(new TeleportTask(pFrom, pTo.getLocation()));
            replace.put("fromPlayer", pFrom.getName());
            replace.put("toPlayer", pTo.getName());
            Utils.sI18n(sender, "tp", replace);
        } else if ((type.equals((Object)Type.Tp.TO) || type.equals((Object)Type.Tp.PLAYERS)) && ACPlayer.getPlayer(pTo.getName()).hasPower(Type.TP_REQUEST)) {
            ACPlayer.getPlayer(pTo).setTpRequest(new TpRequest(pFrom, pTo));
            Utils.sI18n((CommandSender)pTo, "tpRequestTo", "player", pFrom.getName());
            HashMap<String, String> replace2 = new HashMap<String, String>();
            replace2.put("player", pTo.getName());
            if (type.toString().equalsIgnoreCase("to")) {
                replace2.put("tp_type", Utils.I18n("tpTO"));
            } else if (type.toString().equalsIgnoreCase("players")) {
                replace2.put("tp_type", Utils.I18n("tpPLAYERSTO"));
                replace2.put("target", pTo.getName());
            } else {
                replace2.put("tp_type", type.toString());
            }
            Utils.sI18n((CommandSender)pFrom, "tpRequestSend", replace2);
        } else if ((type.equals((Object)Type.Tp.HERE) || type.equals((Object)Type.Tp.PLAYERS)) && ACPlayer.getPlayer(pFrom.getName()).hasPower(Type.TP_REQUEST)) {
            ACPlayer.getPlayer(pFrom).setTpRequest(new TpRequest(pFrom, pTo));
            Utils.sI18n((CommandSender)pFrom, "tpRequestFrom", "player", pTo.getName());
            HashMap<String, String> replace2 = new HashMap<String, String>();
            replace2.put("player", pFrom.getName());
            if (type.toString().equalsIgnoreCase("here")) {
                replace2.put("tp_type", Utils.I18n("tpHERE"));
            } else if (type.toString().equalsIgnoreCase("players")) {
                replace2.put("tp_type", Utils.I18n("tpPLAYERSFROM"));
                replace2.put("target", pFrom.getName());
            } else {
                replace2.put("tp_type", type.toString());
            }
            Utils.sI18n((CommandSender)pTo, "tpRequestSend", replace2);
        } else {
            ACPluginManager.scheduleSyncTask(new TeleportTask(pFrom, pTo.getLocation()));
            replace.put("fromPlayer", pFrom.getName());
            replace.put("toPlayer", pTo.getName());
            Utils.sI18n(sender, "tp", replace);
        }
    }

    public static Long[] transformToElapsedTime(long time) {
        long diff = time;
        long elapsedDays = diff / 86400000L;
        long elapsedHours = (diff %= 86400000L) / 3600000L;
        long elapsedMinutes = (diff %= 3600000L) / 60000L;
        long elapsedSeconds = (diff %= 60000L) / 1000L;
        return new Long[]{elapsedDays, elapsedHours, elapsedMinutes, elapsedSeconds};
    }

    public static boolean weather(CommandSender sender, Type.Weather type, CommandArgs duration) {
        if (Utils.isPlayer(sender, false)) {
            if (duration.length >= 2) {
                World w = sender.getServer().getWorld(duration.getString(1));
                if (w == null) {
                    HashMap<String, String> replace = new HashMap<String, String>();
                    replace.put("world", duration.getString(2));
                    Utils.sI18n(sender, "worldNotFound", replace);
                    return true;
                }
                Utils.weatherChange(sender, w, type, duration);
            } else if ((type.equals((Object)Type.Weather.FREEZE) || type.equals((Object)Type.Weather.CLEAR)) && duration.getString(0) != null) {
                World w = sender.getServer().getWorld(duration.getString(0));
                if (w == null) {
                    HashMap<String, String> replace = new HashMap<String, String>();
                    replace.put("world", duration.getString(0));
                    Utils.sI18n(sender, "worldNotFound", replace);
                    return true;
                }
                Utils.weatherChange(sender, w, type, duration);
            } else {
                Utils.weatherChange(sender, ((Player)sender).getWorld(), type, duration);
            }
        } else if (duration.length >= 2) {
            World w = sender.getServer().getWorld(duration.getString(1));
            if (w == null) {
                HashMap<String, String> replace = new HashMap<String, String>();
                replace.put("world", duration.getString(0));
                Utils.sI18n(sender, "worldNotFound", replace);
                return true;
            }
            Utils.weatherChange(sender, w, type, duration);
        } else if ((type.equals((Object)Type.Weather.FREEZE) || type.equals((Object)Type.Weather.CLEAR)) && duration.getString(0) != null) {
            World w = sender.getServer().getWorld(duration.getString(0));
            if (w == null) {
                HashMap<String, String> replace = new HashMap<String, String>();
                replace.put("world", duration.getString(0));
                Utils.sI18n(sender, "worldNotFound", replace);
                return true;
            }
            Utils.weatherChange(sender, w, type, duration);
        } else {
            for (World w : sender.getServer().getWorlds()) {
                Utils.weatherChange(sender, w, type, duration);
            }
        }
        return true;
    }

    private static void weatherChange(CommandSender sender, World w, Type.Weather type, CommandArgs duration) {
        if (!type.equals((Object)Type.Weather.FREEZE) && !ACWorld.getWorld(w.getName()).getInformation(Type.WEATHER_FROZEN.toString()).isNull()) {
            sender.sendMessage(ChatColor.GOLD + Utils.I18n("wFrozen") + " " + w.getName());
            return;
        }
        switch (type) {
            case CLEAR: {
                w.setThundering(false);
                w.setStorm(false);
                sender.sendMessage(ChatColor.GOLD + Utils.I18n("sClear") + " " + w.getName());
                break;
            }
            case STORM: {
                HashMap<String, String> replace = new HashMap<String, String>();
                if (duration == null || duration.length < 1) {
                    w.setStorm(true);
                    w.setThundering(true);
                    w.setWeatherDuration(12000);
                    replace.put("duration", "10");
                    sender.sendMessage(ChatColor.GOLD + Utils.I18n("sStorm", replace) + w.getName());
                    break;
                }
                try {
                    w.setStorm(true);
                    w.setThundering(true);
                    int time = duration.getInt(0);
                    w.setWeatherDuration(time * 1200);
                    replace.put("duration", String.valueOf(time));
                    sender.sendMessage(ChatColor.GOLD + Utils.I18n("sStorm", replace) + w.getName());
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(ChatColor.BLUE + "Sorry, that (" + duration.getString(0) + ") isn't a number!");
                    w.setStorm(true);
                    w.setWeatherDuration(12000);
                    replace.put("duration", "10");
                    sender.sendMessage(ChatColor.GOLD + Utils.I18n("sStorm", replace) + w.getName());
                }
                break;
            }
            case FREEZE: {
                if (!ACWorld.getWorld(w.getName()).getInformation(Type.WEATHER_FROZEN.toString()).isNull()) {
                    ACWorld.getWorld(w.getName()).removeInformation(Type.WEATHER_FROZEN.toString());
                    sender.sendMessage(ChatColor.GREEN + Utils.I18n("wUnFrozen") + " " + ChatColor.WHITE + w.getName());
                    break;
                }
                ACWorld.getWorld(w.getName()).setInformation(Type.WEATHER_FROZEN.toString(), true);
                sender.sendMessage(ChatColor.RED + Utils.I18n("wFrozen") + " " + ChatColor.WHITE + w.getName());
                break;
            }
            case RAIN: {
                HashMap<String, String> replaceRain = new HashMap<String, String>();
                if (duration == null || duration.length < 1) {
                    w.setStorm(true);
                    w.setThundering(false);
                    w.setWeatherDuration(12000);
                    replaceRain.put("duration", "10");
                    sender.sendMessage(ChatColor.GOLD + Utils.I18n("sRain", replaceRain) + w.getName());
                    break;
                }
                try {
                    w.setStorm(true);
                    w.setThundering(false);
                    int time = duration.getInt(0);
                    w.setWeatherDuration(time * 1200);
                    replaceRain.put("duration", String.valueOf(time));
                    sender.sendMessage(ChatColor.GOLD + Utils.I18n("sRain", replaceRain) + w.getName());
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(ChatColor.BLUE + "Sorry, that (" + duration.getString(0) + ") isn't a number!");
                    w.setStorm(true);
                    w.setWeatherDuration(12000);
                    replaceRain.put("duration", "10");
                    sender.sendMessage(ChatColor.GOLD + Utils.I18n("sRain", replaceRain) + w.getName());
                }
                break;
            }
        }
    }

    public static void teleportWithChunkCheck(Player player, Location loc) {
        CraftServer server = (CraftServer)player.getServer();
        ACTeleportEvent event = new ACTeleportEvent(player, player.getLocation(), loc, PlayerTeleportEvent.TeleportCause.COMMAND);
        server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (!loc.getWorld().isChunkLoaded(loc.getBlockX(), loc.getBlockZ())) {
            loc.getWorld().loadChunk(loc.getBlockX(), loc.getBlockZ());
        }
        ACPlayer.getPlayer(player).setLastLocation(player.getLocation());
        WorldServer fromWorld = ((CraftWorld)player.getLocation().getWorld()).getHandle();
        WorldServer toWorld = ((CraftWorld)loc.getWorld()).getHandle();
        EntityPlayer entity = ((CraftPlayer)player).getHandle();
        if (fromWorld == toWorld) {
            entity.netServerHandler.teleport(loc);
        } else {
            if (entity.activeContainer != entity.defaultContainer) {
                entity.closeInventory();
            }
            server.getHandle().moveToWorld(entity, toWorld.dimension, true, loc);
        }
    }

    public static Collection<String> getPlayerList(CommandSender sender) {
        List<Player> online = Utils.getOnlinePlayers();
        TreeMap<Player, String> players = new TreeMap<Player, String>(new PlayerComparator());
        for (Player p : online) {
            if ((InvisibleWorker.getInstance().hasInvisiblePowers(p) || ACPlayer.getPlayer(p).hasPower(Type.FAKEQUIT)) && !PermissionManager.hasPerm(sender, "admincmd.invisible.cansee", false)) continue;
            players.put(p, Utils.getPlayerName(p, sender));
        }
        return Collections.unmodifiableCollection(players.values());
    }

    private static String timeLongToSring(Long time) {
        return time < 10L ? "0" + time : time.toString();
    }

    public static Map<String, String> playedTime(String playername, long total) {
        Long[] time = Utils.transformToElapsedTime(total);
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("d", time[0].toString());
        replace.put("h", Utils.timeLongToSring(time[1]));
        replace.put("m", Utils.timeLongToSring(time[2]));
        replace.put("s", Utils.timeLongToSring(time[3]));
        replace.put("player", playername);
        return replace;
    }
}

