/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools.Help;

import be.Balor.Tools.Debug.ACLogger;
import be.Balor.Tools.Debug.DebugLog;
import be.Balor.Tools.Help.CmdMatch;
import be.Balor.Tools.Help.HelpEntry;
import be.Balor.Tools.Help.String.ACMinecraftFontWidthCalculator;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.TreeSet;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

class HelpList {
    private TreeSet<HelpEntry> pluginHelp = new TreeSet<HelpEntry>(new EntryNameComparator());
    private final String pluginName;
    private CommandSender lastCommandSender;
    private Queue<HelpEntry> lastHelpEntries;
    private CmdMatch lastCommandSearched;

    HelpList(String plugin) {
        this.pluginName = plugin;
    }

    public void addEntry(HelpEntry he) {
        if (this.pluginHelp.contains(he)) {
            this.pluginHelp.remove(he);
        }
        this.pluginHelp.add(he);
    }

    public boolean removeEntry(String commandName) {
        DebugLog.INSTANCE.info("Remove " + commandName + " help from plugin : " + this.pluginName);
        HelpEntry toRemove = null;
        for (HelpEntry he : this.pluginHelp) {
            if (!he.getCommandName().equals(commandName)) continue;
            toRemove = he;
            break;
        }
        if (toRemove != null) {
            return this.pluginHelp.remove(toRemove);
        }
        return false;
    }

    public HelpList(Plugin plugin) throws IllegalArgumentException {
        TreeSet<HelpEntry> list = new TreeSet<HelpEntry>(new EntryNameComparator());
        Map cmds = plugin.getDescription().getCommands();
        this.pluginName = plugin.getDescription().getName();
        if (cmds == null) {
            throw new IllegalArgumentException(this.pluginName + " don't have any commands to list");
        }
        ArrayList<String> perms = new ArrayList<String>();
        try {
            for (Map.Entry k : cmds.entrySet()) {
                Map value = (Map)k.getValue();
                if (value.containsKey("permission") && value.get("permission") != null && !value.get("permission").equals("")) {
                    perms.add(value.get("permission").toString());
                } else if (value.containsKey("permissions") && value.get("permissions") != null && !value.get("permissions").equals("")) {
                    perms.add(value.get("permissions").toString());
                }
                String desc = value.get("description").toString();
                list.add(new HelpEntry((String)k.getKey(), desc == null ? "" : desc, "", new ArrayList<String>(perms), (String)k.getKey()));
                perms.clear();
            }
            this.pluginHelp = list;
        }
        catch (Exception e) {
            StackTraceElement[] trace;
            if (ConfigEnum.VERBOSE.getBoolean()) {
                ACLogger.warning("[HELP] Problem with commands of " + this.pluginName);
            }
            DebugLog.INSTANCE.warning("[HELP] " + e.toString());
            for (StackTraceElement element : trace = e.getStackTrace()) {
                DebugLog.INSTANCE.warning("[HELP] " + element.toString());
            }
            this.pluginHelp = new TreeSet<HelpEntry>(new EntryNameComparator());
        }
    }

    public String getPluginName() {
        return this.pluginName;
    }

    private void checkPermissions(CommandSender sender) {
        if (this.lastCommandSender != null && sender.equals(this.lastCommandSender)) {
            return;
        }
        this.lastHelpEntries = new PriorityQueue<HelpEntry>(this.pluginHelp.size() / 2, new EntryCommandComparator());
        this.lastCommandSender = sender;
        for (HelpEntry he : this.pluginHelp) {
            if (!he.hasPerm(sender)) continue;
            this.lastHelpEntries.add(he);
        }
    }

    public List<String> getPage(int page, CommandSender sender, boolean detailed) {
        int entryPerPage = ConfigEnum.H_ENTRY.getInt();
        ArrayList<String> helpList = new ArrayList<String>();
        this.checkPermissions(sender);
        int maxPages = (int)Math.ceil((double)this.lastHelpEntries.size() / (double)entryPerPage);
        page = page > maxPages ? maxPages : page;
        int start = (page - 1) * entryPerPage;
        int end = start + entryPerPage > this.lastHelpEntries.size() ? this.lastHelpEntries.size() : start + entryPerPage;
        helpList.add(ChatColor.AQUA + ACMinecraftFontWidthCalculator.strPadCenterChat(ChatColor.DARK_GREEN + " " + this.pluginName + " (" + page + "/" + maxPages + ") " + ChatColor.AQUA, '='));
        HelpEntry[] array = this.lastHelpEntries.toArray(new HelpEntry[0]);
        if (Utils.isPlayer(sender, false)) {
            for (int i = start; i < end; ++i) {
                HelpEntry he = array[i];
                helpList.add(he.chatString(detailed));
            }
        } else {
            for (int i = start; i < end; ++i) {
                HelpEntry he = array[i];
                helpList.add(he.consoleString(detailed));
            }
        }
        return helpList;
    }

    public List<String> getPage(int page, CommandSender sender) {
        return this.getPage(page, sender, false);
    }

    public List<HelpEntry> getCommandMatch(String cmd, CommandSender sender, boolean detailed) {
        ArrayList<HelpEntry> result = new ArrayList<HelpEntry>();
        if (cmd == null) {
            return null;
        }
        if (this.lastCommandSearched != null && this.lastCommandSearched.getCmd().equals(cmd)) {
            return this.lastCommandSearched.getResult();
        }
        String lowerSearch = cmd.toLowerCase().trim();
        for (HelpEntry entry : this.pluginHelp) {
            String str = entry.getCommand().trim();
            if (!str.toLowerCase().startsWith(lowerSearch) || !entry.hasPerm(sender)) continue;
            result.add(entry);
        }
        if (result.isEmpty()) {
            for (HelpEntry entry : this.pluginHelp) {
                if (!entry.hasPerm(sender) || !entry.getDescription().toLowerCase().contains(lowerSearch)) continue;
                result.add(entry);
            }
        }
        this.lastCommandSearched = new CmdMatch(cmd, result);
        return result;
    }

    public HelpEntry getExactCommand(String cmd) {
        for (HelpEntry entry : this.pluginHelp) {
            if (!entry.getCommandName().equals(cmd)) continue;
            return entry;
        }
        return null;
    }

    public List<HelpEntry> getCommandMatch(String cmd, CommandSender sender) {
        return this.getCommandMatch(cmd, sender, false);
    }

    private static class EntryCommandComparator
    implements Comparator<HelpEntry> {
        boolean descending = true;

        private EntryCommandComparator() {
        }

        @Override
        public int compare(HelpEntry o1, HelpEntry o2) {
            return o1.getCommand().compareTo(o2.getCommand()) * (this.descending ? 1 : -1);
        }
    }

    private static class EntryNameComparator
    implements Comparator<HelpEntry> {
        boolean descending = true;

        private EntryNameComparator() {
        }

        @Override
        public int compare(HelpEntry o1, HelpEntry o2) {
            return o1.getCommandName().compareTo(o2.getCommandName()) * (this.descending ? 1 : -1);
        }
    }
}

