/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools.Help;

import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Tools.Help.String.ACMinecraftFontWidthCalculator;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import java.util.Iterator;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

class HelpEntry {
    private final String command;
    private final String description;
    private final String detailedDesc;
    private final List<String> permissions;
    private final String commandName;

    HelpEntry(String command, String description, String detailedDesc, List<String> permissions, String commandName) {
        this.command = command;
        this.description = description;
        this.detailedDesc = detailedDesc;
        this.permissions = permissions;
        this.commandName = commandName;
    }

    public boolean hasPerm(CommandSender p) {
        Iterator<String> i$ = this.permissions.iterator();
        if (i$.hasNext()) {
            String perm = i$.next();
            if (perm.equals("OP")) {
                if (Utils.isPlayer(p, false)) {
                    return p.isOp();
                }
                return true;
            }
            return PermissionManager.hasPerm(p, perm, false);
        }
        return true;
    }

    public String toString() {
        return String.format("%s/%s%s : %s%s", ChatColor.GOLD, this.command, ChatColor.WHITE.toString(), ChatColor.WHITE, this.description).replace("[", ChatColor.RED + "[").replace("]", "]" + ChatColor.GOLD);
    }

    public String chatString(boolean detailed) {
        int descriptionSize;
        String line = this.getFormatedCmd();
        int sizeRemaining = 318 - ACMinecraftFontWidthCalculator.getStringWidth(line);
        if (detailed && !this.detailedDesc.equals("")) {
            descriptionSize = ACMinecraftFontWidthCalculator.strLen(this.detailedDesc);
            line = line + ACMinecraftFontWidthCalculator.strPadLeftChat(this.detailedDesc.replace("[", ChatColor.DARK_RED + "[").replace("]", "]" + ChatColor.WHITE), sizeRemaining, ' ');
        } else {
            descriptionSize = ACMinecraftFontWidthCalculator.strLen(this.description);
            line = line + ACMinecraftFontWidthCalculator.strPadLeftChat(this.description.replace("[", ChatColor.DARK_RED + "[").replace("]", "]" + ChatColor.WHITE), sizeRemaining, ' ');
        }
        if (ConfigEnum.H_SHORTE.getBoolean()) {
            return ACMinecraftFontWidthCalculator.strChatTrim(line);
        }
        if (sizeRemaining > descriptionSize || !ConfigEnum.H_WRAP.getBoolean()) {
            return line;
        }
        if (ConfigEnum.H_RWRAP.getBoolean()) {
            return ACMinecraftFontWidthCalculator.strChatWordWrapRight(line, 10, ' ', ':');
        }
        return ACMinecraftFontWidthCalculator.strChatWordWrap(line, 10);
    }

    public String consoleString(boolean detailed) {
        int descriptionSize;
        int width = System.getProperty("os.name").startsWith("Windows") ? 63 : 90;
        String line = this.getFormatedCmd();
        int sizeRemaining = width - ACMinecraftFontWidthCalculator.strLen(line);
        if (detailed && !this.detailedDesc.equals("")) {
            descriptionSize = ACMinecraftFontWidthCalculator.strLen(this.detailedDesc);
            line = line + ACMinecraftFontWidthCalculator.unformattedPadLeft(this.detailedDesc.replace("[", ChatColor.DARK_RED + "[").replace("]", "]" + ChatColor.WHITE), sizeRemaining, ' ');
        } else {
            descriptionSize = ACMinecraftFontWidthCalculator.strLen(this.description);
            line = line + ACMinecraftFontWidthCalculator.unformattedPadLeft(this.description.replace("[", ChatColor.DARK_RED + "[").replace("]", "]" + ChatColor.WHITE), sizeRemaining, ' ');
        }
        if (ConfigEnum.H_SHORTE.getBoolean()) {
            return ACMinecraftFontWidthCalculator.strTrim(line, width);
        }
        if (sizeRemaining > descriptionSize || !ConfigEnum.H_WRAP.getBoolean()) {
            return line;
        }
        if (ConfigEnum.H_RWRAP.getBoolean()) {
            return ACMinecraftFontWidthCalculator.strWordWrapRight(line, width, 10, ' ', ':');
        }
        return ACMinecraftFontWidthCalculator.strWordWrap(line, width, 10);
    }

    private String getFormatedCmd() {
        return String.format("%s/%s%s : ", ChatColor.GOLD, this.command.replace("[", ChatColor.DARK_RED + "[").replace("]", "]" + ChatColor.GOLD), ChatColor.WHITE);
    }

    public String getCommand() {
        return this.command;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDetailedDesc() {
        return this.detailedDesc;
    }
}

