/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools.Files;

import be.Balor.Tools.Egg.EggType;
import be.Balor.Tools.TpRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ObjectContainer {
    private final Object obj;

    public ObjectContainer(Object obj) {
        this.obj = obj;
    }

    public boolean isNull() {
        return this.obj == null;
    }

    public String getString() {
        if (this.obj == null) {
            return null;
        }
        return this.obj.toString();
    }

    public TpRequest getTpRequest() {
        if (this.obj == null || !(this.obj instanceof TpRequest)) {
            return null;
        }
        return (TpRequest)this.obj;
    }

    public EggType<?> getEggType() {
        if (this.obj == null || !(this.obj instanceof EggType)) {
            return null;
        }
        return (EggType)this.obj;
    }

    public int getInt(int def) {
        Integer o = ObjectContainer.castInt(this.obj);
        if (o == null) {
            return def;
        }
        return o;
    }

    public float getFloat(float def) {
        Float o = ObjectContainer.castFloat(this.obj);
        if (o == null) {
            return def;
        }
        return o.floatValue();
    }

    public double getDouble(double def) {
        Double o = ObjectContainer.castDouble(this.obj);
        if (o == null) {
            return def;
        }
        return o;
    }

    public boolean getBoolean(boolean def) {
        Boolean o = ObjectContainer.castBoolean(this.obj);
        if (o == null) {
            return def;
        }
        return o;
    }

    public long getLong(long def) {
        Long o = ObjectContainer.castLong(this.obj);
        if (o == null) {
            return def;
        }
        return o;
    }

    public List<Object> getList() {
        Object o = this.obj;
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            return (List)o;
        }
        return null;
    }

    public List<String> getStringList(List<String> def) {
        List<Object> raw = this.getList();
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : raw) {
            if (o == null) continue;
            list.add(o.toString());
        }
        return list;
    }

    public List<Integer> getIntList(List<Integer> def) {
        List<Object> raw = this.getList();
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Object o : raw) {
            Integer i = ObjectContainer.castInt(o);
            if (i == null) continue;
            list.add(i);
        }
        return list;
    }

    public List<Double> getDoubleList(List<Double> def) {
        List<Object> raw = this.getList();
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<Double> list = new ArrayList<Double>();
        for (Object o : raw) {
            Double i = ObjectContainer.castDouble(o);
            if (i == null) continue;
            list.add(i);
        }
        return list;
    }

    public List<Boolean> getBooleanList(List<Boolean> def) {
        List<Object> raw = this.getList();
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        for (Object o : raw) {
            Boolean tetsu = ObjectContainer.castBoolean(o);
            if (tetsu == null) continue;
            list.add(tetsu);
        }
        return list;
    }

    private static Integer castInt(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Byte) {
            return (int)((Byte)o);
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Double) {
            return (int)((Double)o).doubleValue();
        }
        if (o instanceof Float) {
            return (int)((Float)o).floatValue();
        }
        if (o instanceof Long) {
            return (int)((Long)o).longValue();
        }
        return null;
    }

    private static Double castDouble(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Byte) {
            return (double)((Byte)o);
        }
        if (o instanceof Integer) {
            return (double)((Integer)o);
        }
        if (o instanceof Long) {
            return (double)((Long)o);
        }
        return null;
    }

    private static Boolean castBoolean(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return null;
    }

    private static Long castLong(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Float) {
            return Long.parseLong(((Float)o).toString());
        }
        if (o instanceof Double) {
            return Long.parseLong(((Double)o).toString());
        }
        if (o instanceof Byte) {
            return Long.parseLong(((Byte)o).toString());
        }
        if (o instanceof Integer) {
            return Long.parseLong(((Integer)o).toString());
        }
        return null;
    }

    private static Float castFloat(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Float) {
            return (Float)o;
        }
        if (o instanceof Long) {
            return Float.valueOf(Float.parseFloat(((Long)o).toString()));
        }
        if (o instanceof Double) {
            return Float.valueOf(Float.parseFloat(((Double)o).toString()));
        }
        if (o instanceof Byte) {
            return Float.valueOf(Float.parseFloat(((Byte)o).toString()));
        }
        if (o instanceof Integer) {
            return Float.valueOf(Float.parseFloat(((Integer)o).toString()));
        }
        return null;
    }

    public String toString() {
        if (this.obj instanceof List) {
            return Arrays.toString(((List)this.obj).toArray(new String[0]));
        }
        return this.obj.toString();
    }

    public Object getObj() {
        return this.obj;
    }
}

