/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools.Files;

import be.Balor.Tools.Files.KitInstance;
import be.Balor.Tools.MaterialContainer;
import be.Balor.Tools.Type;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class ArmoredKitInstance
extends KitInstance {
    protected final Map<Type.ArmorPart, MaterialContainer> armor = new EnumMap<Type.ArmorPart, MaterialContainer>(Type.ArmorPart.class);

    public ArmoredKitInstance(String name, int delay, List<MaterialContainer> items, Map<Type.ArmorPart, MaterialContainer> armor) {
        super(name, delay, items);
        for (Map.Entry<Type.ArmorPart, MaterialContainer> e : armor.entrySet()) {
            if (!e.getKey().isValid(e.getValue().getMaterial().getId())) continue;
            this.armor.put(e.getKey(), e.getValue());
        }
    }

    public ArmoredKitInstance(KitInstance kit) {
        super(kit.name, kit.delay, kit.items);
    }

    public ItemStack getArmorPart(Type.ArmorPart part) {
        MaterialContainer mat = this.armor.get((Object)part);
        if (mat == null) {
            return null;
        }
        return mat.getItemStack();
    }

    public Type.ArmorPart[] setPlayerArmorParts(Player p) {
        ArrayList<Type.ArmorPart> armorParts = new ArrayList<Type.ArmorPart>(Type.ArmorPart.values().length);
        final ItemStack[] armors = new ItemStack[Type.ArmorPart.values().length];
        final PlayerInventory inventory = p.getInventory();
        if (ConfigEnum.ARMOR_KIT_OVERRIDE.getBoolean()) {
            for (Type.ArmorPart part : Type.ArmorPart.values()) {
                ItemStack toadd = this.getArmorPart(part);
                if (toadd == null) {
                    toadd = inventory.getItem(inventory.getSize() + part.getPlaceInInventory());
                    armorParts.add(part);
                }
                armors[part.getPlaceInInventory()] = toadd;
            }
        } else {
            for (Type.ArmorPart part : Type.ArmorPart.values()) {
                ItemStack toadd = this.getArmorPart(part);
                if (inventory.getItem(inventory.getSize() + part.getPlaceInInventory()) != null) continue;
                if (toadd == null) {
                    toadd = inventory.getItem(inventory.getSize() + part.getPlaceInInventory());
                    armorParts.add(part);
                }
                armors[part.getPlaceInInventory()] = toadd;
            }
        }
        ACPluginManager.scheduleSyncTask(new Runnable(){

            @Override
            public void run() {
                inventory.setArmorContents(armors);
            }
        });
        return armorParts.toArray(new Type.ArmorPart[0]);
    }

    @Override
    public void addParent(KitInstance parent) {
        super.addParent(parent);
        if (!(parent instanceof ArmoredKitInstance)) {
            return;
        }
        ArmoredKitInstance armoredParent = (ArmoredKitInstance)parent;
        for (Type.ArmorPart part : Type.ArmorPart.values()) {
            if (this.armor.get((Object)part) != null) continue;
            this.armor.put(part, armoredParent.armor.get((Object)part));
        }
    }
}

