/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools.Egg;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Tools.Egg.EggPermissionManager;
import be.Balor.Tools.Egg.EggTypeClassLoader;
import be.Balor.Tools.Egg.Exceptions.DontHaveThePermissionException;
import be.Balor.Tools.Egg.Exceptions.ExceptionType;
import be.Balor.Tools.Egg.Exceptions.ParameterMissingException;
import be.Balor.Tools.Egg.Exceptions.ProcessingArgsException;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.LocaleHelper;
import java.io.Serializable;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerEggThrowEvent;
import org.bukkit.permissions.Permission;

public abstract class EggType<T>
implements Serializable {
    private static final long serialVersionUID = 2793422400211176328L;
    protected T value;
    private static final ClassLoader eggTypeLoader = new EggTypeClassLoader();

    public abstract void onEvent(PlayerEggThrowEvent var1);

    protected abstract void processArguments(Player var1, CommandArgs var2) throws ProcessingArgsException;

    protected boolean checkPermission(Player player) throws DontHaveThePermissionException {
        Permission perm = EggPermissionManager.INSTANCE.getPermission(this);
        if (!PermissionManager.hasPerm((CommandSender)player, perm, false)) {
            throw new DontHaveThePermissionException(Utils.I18n("errorNotPerm", "p", perm.getName()));
        }
        return true;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public static EggType<?> createEggType(Player player, CommandArgs args) throws ProcessingArgsException, DontHaveThePermissionException, NullPointerException {
        EggType<?> eggType;
        if (!args.hasFlag('E')) {
            throw new ParameterMissingException('E', LocaleHelper.EGG_PARAM.getLocale());
        }
        String className = args.getValueFlag('E');
        try {
            eggType = EggType.matchEggClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new ProcessingArgsException(ExceptionType.NO_CLASS, className, e);
        }
        catch (InstantiationException e) {
            throw new ProcessingArgsException(ExceptionType.INSTANCE, className, e);
        }
        catch (IllegalAccessException e) {
            throw new ProcessingArgsException(ExceptionType.ILLEGAL_ACCESS, className, e);
        }
        catch (NullPointerException e) {
            throw new NullPointerException();
        }
        eggType.checkPermission(player);
        eggType.processArguments(player, args);
        return eggType;
    }

    private static EggType<?> matchEggClass(String name) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NullPointerException {
        Class<?> c = eggTypeLoader.loadClass(name);
        return (EggType)c.newInstance();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " = " + this.getValue();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EggType)) {
            return false;
        }
        EggType other = (EggType)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

