/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools;

import be.Balor.Tools.Debug.DebugLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

public final class Downloader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(String urlString, File downloaded) throws IOException {
        FilterOutputStream bout = null;
        BufferedInputStream in = null;
        HttpURLConnection connection = null;
        if (!Downloader.exists(urlString)) {
            throw new FileNotFoundException("The remote file " + urlString + " can't be found.");
        }
        if (downloaded.getParentFile() != null && !downloaded.getParentFile().exists()) {
            downloaded.getParentFile().mkdirs();
        }
        if (!Downloader.checkVersionToDownload(urlString, downloaded)) {
            return;
        }
        if (downloaded.exists()) {
            downloaded.delete();
        }
        DebugLog.INSTANCE.info("Downloading file : " + urlString);
        try {
            URL url = new URL(urlString);
            connection = (HttpURLConnection)url.openConnection();
            int filesize = connection.getContentLength();
            float totalDataRead = 0.0f;
            in = new BufferedInputStream(connection.getInputStream());
            FileOutputStream fos = new FileOutputStream(downloaded);
            byte[] data = new byte[1024];
            bout = new BufferedOutputStream(fos, data.length);
            int i = 0;
            int oldPercent = 0;
            while ((i = in.read(data, 0, data.length)) >= 0) {
                ((BufferedOutputStream)bout).write(data, 0, i);
                int percent = (int)((totalDataRead += (float)i) * 100.0f / (float)filesize);
                if (percent - oldPercent < 10) continue;
                DebugLog.INSTANCE.info("Downloaded at " + percent + "%");
                oldPercent = percent;
            }
        }
        finally {
            if (bout != null) {
                bout.close();
            }
            if (in != null) {
                in.close();
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
        DebugLog.INSTANCE.info("File " + urlString + " downloaded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean checkVersionToDownload(String fileUrl, File download) throws IOException {
        String urlString = fileUrl + ".version";
        File versionFile = new File(download.getParent(), download.getName() + ".version");
        if (!Downloader.exists(urlString)) {
            return true;
        }
        HttpURLConnection connection = null;
        try {
            String curVersion;
            connection = (HttpURLConnection)new URL(urlString).openConnection();
            String version = Downloader.readVersion(connection.getInputStream());
            if (versionFile.exists() && (curVersion = Downloader.readVersion(new FileInputStream(versionFile))).equals(version) && download.exists()) {
                boolean bl = false;
                return bl;
            }
            Downloader.writeVersion(versionFile, version);
            boolean bl = true;
            return bl;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean exists(String URLName) throws IOException {
        HttpURLConnection con = null;
        try {
            HttpURLConnection.setFollowRedirects(false);
            con = (HttpURLConnection)new URL(URLName).openConnection();
            con.setRequestMethod("HEAD");
            boolean bl = con.getResponseCode() == 200;
            return bl;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readVersion(InputStream stream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        try {
            String string = reader.readLine();
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeVersion(File file, String version) throws IOException {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(file));
            out.write(version);
            out.flush();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

