/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools.Debug;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private static final String DEFAULT_FORMAT = "%t [%L] *%C.%M* : %m [%T] %S";
    private final MessageFormat messageFormat;
    private final DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");

    public LogFormatter() {
        String propName = this.getClass().getName() + ".format";
        String format = LogManager.getLogManager().getProperty(propName);
        if (format == null || format.trim().length() == 0) {
            format = DEFAULT_FORMAT;
        }
        if (format.contains("{") || format.contains("}")) {
            throw new IllegalArgumentException("curly braces not allowed");
        }
        format = format.replace("%L", "{0}").replace("%m", "{1}").replace("%M", "{2}").replace("%t", "{3}").replace("%c", "{4}").replace("%T", "{5}").replace("%n", "{6}").replace("%C", "{7}").replace("%S", "{8}") + "\n";
        this.messageFormat = new MessageFormat(format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(LogRecord record) {
        Throwable thrown;
        String[] arguments = new String[9];
        arguments[0] = record.getLevel().toString();
        arguments[1] = record.getMessage();
        if ((arguments[1] == null || arguments[1].length() == 0) && (thrown = record.getThrown()) != null) {
            arguments[1] = thrown.getMessage();
        }
        arguments[1] = record.getMessage();
        arguments[2] = record.getSourceMethodName() != null ? record.getSourceMethodName() : "?";
        Date date = new Date(record.getMillis());
        DateFormat dateFormat = this.dateFormat;
        synchronized (dateFormat) {
            arguments[3] = this.dateFormat.format(date);
        }
        arguments[4] = record.getSourceClassName() != null ? record.getSourceClassName() : "?";
        arguments[5] = Integer.valueOf(record.getThreadID()).toString();
        arguments[6] = record.getLoggerName();
        int start = arguments[4].lastIndexOf(".") + 1;
        arguments[7] = start > 0 && start < arguments[4].length() ? arguments[4].substring(start) : arguments[4];
        if (record.getThrown() == null) {
            arguments[8] = "";
        } else {
            arguments[1] = record.getMessage() != null ? arguments[1] + " " + record.getThrown().toString() : record.getThrown().toString();
            String stackTrace = "\n";
            for (StackTraceElement st : record.getThrown().getStackTrace()) {
                stackTrace = stackTrace + "\t" + st.toString() + "\n";
            }
            arguments[8] = stackTrace;
        }
        MessageFormat messageFormat = this.messageFormat;
        synchronized (messageFormat) {
            return this.messageFormat.format(arguments);
        }
    }
}

