/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools.Configuration.File;

import be.Balor.Tools.Configuration.ExMemoryConfiguration;
import be.Balor.Tools.Configuration.File.ExFileConfigurationOptions;
import be.Balor.Tools.Debug.ACLogger;
import be.Balor.Tools.Files.Unicode.UnicodeReader;
import be.Balor.Tools.Files.Unicode.UnicodeUtil;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;

public abstract class ExFileConfiguration
extends ExMemoryConfiguration {
    protected File file;
    protected boolean corrupted = false;

    public ExFileConfiguration() {
    }

    public ExFileConfiguration(Configuration defaults) {
        super(defaults);
    }

    protected abstract String buildHeader();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExFileConfiguration)) {
            return false;
        }
        ExFileConfiguration other = (ExFileConfiguration)obj;
        return !(this.file == null ? other.file != null : !this.file.equals(other.file));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        return result;
    }

    public void load(File file) throws FileNotFoundException, IOException, InvalidConfigurationException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        this.file = file;
        try {
            this.load(new FileInputStream(this.file));
        }
        catch (IllegalArgumentException e) {
            ACLogger.severe("Problem with File : " + this.file);
            ACLogger.severe(e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream stream) throws IOException, InvalidConfigurationException {
        if (stream == null) {
            throw new IllegalArgumentException("Stream cannot be null");
        }
        StringBuilder builder = new StringBuilder();
        BufferedReader input = new BufferedReader(new UnicodeReader(stream, "UTF-8"));
        try {
            String line;
            while ((line = input.readLine()) != null) {
                builder.append(line);
                builder.append('\n');
            }
        }
        finally {
            input.close();
        }
        this.loadFromString(builder.toString());
    }

    public void load(String file) throws FileNotFoundException, IOException, InvalidConfigurationException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        this.load(new File(file));
    }

    public abstract void loadFromString(String var1) throws InvalidConfigurationException;

    @Override
    public ExFileConfigurationOptions options() {
        if (this.options == null) {
            this.options = new ExFileConfigurationOptions(this);
        }
        return (ExFileConfigurationOptions)this.options;
    }

    public void save(File file) throws IOException {
        if (this.corrupted) {
            return;
        }
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            Files.createParentDirs((File)file);
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        UnicodeUtil.saveUTF8File(file, this.saveToString(), false);
    }

    public void save(String file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        this.save(new File(file));
    }

    public abstract String saveToString();

    public String toString() {
        return "ExFileConfiguration [file=" + this.file + "]";
    }
}

