/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Tools.Configuration;

import be.Balor.Tools.Configuration.ExConfigurationSection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemorySection;

public class ExMemorySection
extends MemorySection
implements ExConfigurationSection {
    protected final Lock lock = new ReentrantLock(true);

    public ExMemorySection() {
    }

    protected ExMemorySection(ConfigurationSection exMemorySection, String key) {
        super(exMemorySection, key);
    }

    @Override
    public boolean add(String path, Object value) {
        if (this.isSet(path)) {
            return false;
        }
        this.set(path, value);
        return true;
    }

    @Override
    public ExConfigurationSection addSection(String path) {
        ExConfigurationSection result = this.getConfigurationSection(path);
        if (result == null) {
            result = this.createSection(path);
        }
        return result;
    }

    private long castToLong(Object value) throws NumberFormatException {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        throw new NumberFormatException();
    }

    @Override
    public ExConfigurationSection createSection(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException("Cannot create section at empty path");
        }
        String[] split = path.split(Pattern.quote(Character.toString(this.getRoot().options().pathSeparator())));
        ExConfigurationSection section = this;
        for (int i = 0; i < split.length - 1; ++i) {
            ExMemorySection last = section;
            section = this.getConfigurationSection(split[i]);
            if (section != null) continue;
            section = last.createSection(split[i]);
        }
        String key = split[split.length - 1];
        if (section == this) {
            ExMemorySection result = new ExMemorySection(this, key);
            this.map.put(key, result);
            return result;
        }
        return section.createSection(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String path, Object def) {
        Object info;
        this.lock.lock();
        try {
            info = super.get(path, def);
        }
        finally {
            this.lock.unlock();
        }
        return info;
    }

    @Override
    public List<Boolean> getBooleanList(String path, List<Boolean> def) {
        List result = super.getBooleanList(path);
        if (result == null || result != null && result.isEmpty()) {
            return def;
        }
        return result;
    }

    @Override
    public ExConfigurationSection getConfigurationSection(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        Object val = this.get(path, this.getDefault(path));
        return val instanceof ExConfigurationSection ? (ExConfigurationSection)val : null;
    }

    @Override
    public List<Double> getDoubleList(String path, List<Double> def) {
        List result = super.getDoubleList(path);
        if (result == null || result != null && result.isEmpty()) {
            return def;
        }
        return result;
    }

    @Override
    public List<Integer> getIntList(String path, List<Integer> def) {
        List result = this.getIntegerList(path);
        if (result == null || result != null && result.isEmpty()) {
            return def;
        }
        return result;
    }

    public long getLong(String path, long def) {
        long returnVal;
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        Object val = this.get(path, def);
        try {
            returnVal = this.castToLong(val);
        }
        catch (NumberFormatException e) {
            returnVal = def;
        }
        return returnVal;
    }

    public String getString(String path, String def) {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        Object val = this.get(path, def);
        if (val == null) {
            return def;
        }
        return val instanceof String ? (String)val : val.toString();
    }

    @Override
    public List<String> getStringList(String path, List<String> def) {
        List result = super.getStringList(path);
        if (result == null || result != null && result.isEmpty()) {
            return def;
        }
        return result;
    }

    @Override
    public void remove(String path) {
        this.set(path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String path, Object value) {
        this.lock.lock();
        try {
            super.set(path, value);
        }
        finally {
            this.lock.unlock();
        }
    }
}

