/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Player;

import be.Balor.Player.ACPlayer;
import be.Balor.Player.EmptyPlayer;
import be.Balor.Player.IPlayerFactory;
import be.Balor.Tools.Debug.ACLogger;
import be.Balor.Tools.Debug.DebugLog;
import be.Balor.Tools.Type;
import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.entity.Player;

public class PlayerManager {
    private final ConcurrentMap<String, ACPlayer> players = new MapMaker().concurrencyLevel(8).weakValues().makeMap();
    private final ConcurrentMap<ACPlayer, Boolean> onlinePlayers = new MapMaker().concurrencyLevel(8).makeMap();
    private static final PlayerManager instance = new PlayerManager();
    private IPlayerFactory playerFactory;

    private PlayerManager() {
        EmptyPlayer console = new EmptyPlayer("serverConsole");
        this.onlinePlayers.put(console, true);
        this.addPlayer(console);
    }

    public static PlayerManager getInstance() {
        return instance;
    }

    public void setPlayerFactory(IPlayerFactory playerFactory) {
        this.playerFactory = playerFactory;
    }

    public void convertFactory(IPlayerFactory factory) {
        ACLogger.info("Converting player to the new type.");
        for (String name : this.playerFactory.getExistingPlayers()) {
            factory.addExistingPlayer(name);
            ACPlayer oldPlayer = this.playerFactory.createPlayer(name);
            ACPlayer newPlayer = factory.createPlayer(name);
            newPlayer.setLastLocation(oldPlayer.getLastLocation());
            newPlayer.setPresentation(oldPlayer.getPresentation());
            for (String string : oldPlayer.getHomeList()) {
                newPlayer.setHome(string, oldPlayer.getHome(string));
            }
            for (Map.Entry entry : oldPlayer.getPowers().entrySet()) {
                Type power = Type.matchType((String)entry.getKey());
                if (power != null) {
                    newPlayer.setPower(power, oldPlayer.getPower(power).getObj());
                    continue;
                }
                newPlayer.setCustomPower((String)entry.getKey(), oldPlayer.getCustomPower((String)entry.getKey()).getObj());
            }
            for (String string : oldPlayer.getInformationsList()) {
                if (string.equals("lastLoc") || string.equals("presentation")) continue;
                newPlayer.setInformation(string, oldPlayer.getInformation(string).getObj());
            }
            for (String string : oldPlayer.getKitUseList()) {
                newPlayer.setLastKitUse(string, oldPlayer.getLastKitUse(string));
            }
            newPlayer.forceSave();
        }
        this.playerFactory = factory;
        ACLogger.info("Convertion finished.");
    }

    private synchronized boolean addPlayer(ACPlayer player) {
        String name = player.getName();
        if (name == null) {
            throw new NullPointerException();
        }
        ACPlayer ref = (ACPlayer)this.players.get(name);
        if (ref != null) {
            return false;
        }
        this.players.put(name, player);
        return true;
    }

    public List<ACPlayer> getOnlineACPlayers() {
        return new ArrayList<ACPlayer>(this.onlinePlayers.keySet());
    }

    public List<Player> getOnlinePlayers() {
        ArrayList<Player> list = new ArrayList<Player>(this.onlinePlayers.size());
        for (ACPlayer p : this.onlinePlayers.keySet()) {
            Player handler = p.getHandler();
            if (handler == null) continue;
            list.add(handler);
        }
        return list;
    }

    List<ACPlayer> getACPlayerHavingPower(String power) {
        ArrayList<ACPlayer> list = new ArrayList<ACPlayer>();
        for (ACPlayer p : this.getExistingPlayers()) {
            if (!p.hasCustomPower(power)) continue;
            list.add(p);
        }
        return list;
    }

    List<ACPlayer> getACPlayerHavingPower(Type power) {
        ArrayList<ACPlayer> list = new ArrayList<ACPlayer>();
        for (ACPlayer p : this.getExistingPlayers()) {
            if (!p.hasPower(power)) continue;
            list.add(p);
        }
        return list;
    }

    public List<ACPlayer> getExistingPlayers() {
        ArrayList<ACPlayer> list = new ArrayList<ACPlayer>();
        for (String name : this.playerFactory.getExistingPlayers()) {
            ACPlayer player = this.demandACPlayer(name);
            if (player instanceof EmptyPlayer) continue;
            list.add(player);
        }
        return list;
    }

    private synchronized ACPlayer getPlayer(String name) {
        ACPlayer result = (ACPlayer)this.players.get(name);
        return result;
    }

    public boolean setOffline(ACPlayer player) {
        player.updatePlayedTime();
        player.forceSave();
        player.setOnline(false);
        return this.onlinePlayers.remove(player) != null;
    }

    public ACPlayer setOnline(Player player) {
        this.playerFactory.addExistingPlayer(player.getName());
        ACPlayer acPlayer = this.demandACPlayer(player);
        this.onlinePlayers.put(acPlayer, true);
        acPlayer.setOnline(true);
        DebugLog.INSTANCE.info(player.getName() + " is put online.");
        return acPlayer;
    }

    ACPlayer demandACPlayer(String name) {
        if (name == null) {
            return this.getPlayer("serverConsole");
        }
        ACPlayer result = this.getPlayer(name);
        if (result == null) {
            result = this.playerFactory.createPlayer(name);
            this.addPlayer(result);
            result = this.getPlayer(name);
        } else if (result instanceof EmptyPlayer) {
            ACPlayer tmp = this.playerFactory.createPlayer(name);
            if (tmp instanceof EmptyPlayer) {
                return result;
            }
            this.players.remove(name);
            this.onlinePlayers.remove(result);
            result = tmp;
            this.addPlayer(result);
            result = this.getPlayer(name);
        }
        return result;
    }

    ACPlayer demandACPlayer(Player player) {
        if (player == null) {
            return this.getPlayer("serverConsole");
        }
        String playerName = player.getName();
        ACPlayer result = this.getPlayer(playerName);
        if (result == null) {
            result = this.playerFactory.createPlayer(player);
            this.addPlayer(result);
            result = this.getPlayer(playerName);
        } else if (result instanceof EmptyPlayer) {
            ACPlayer tmp = this.playerFactory.createPlayer(playerName);
            if (tmp instanceof EmptyPlayer) {
                return result;
            }
            this.players.remove(playerName);
            this.onlinePlayers.remove(result);
            result = tmp;
            this.addPlayer(result);
            result = this.getPlayer(playerName);
        }
        return result;
    }
}

