/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Player;

import be.Balor.Player.ACPlayer;
import be.Balor.Player.EmptyPlayer;
import be.Balor.Player.FilePlayer;
import be.Balor.Player.IPlayerFactory;
import be.Balor.Tools.Debug.DebugLog;
import be.Balor.Tools.Files.YmlFilter;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.entity.Player;

public class FilePlayerFactory
implements IPlayerFactory {
    final String directory;
    private final Set<String> existingPlayers = new HashSet<String>();

    public FilePlayerFactory(String directory) {
        this.directory = directory;
        File[] players = YmlFilter.listRecursively(new File(directory), 1);
        StringBuffer files = new StringBuffer();
        for (File player : players) {
            String name = player.getName();
            this.existingPlayers.add(name.substring(0, name.lastIndexOf(46)));
            files.append(name + " ");
        }
        DebugLog.INSTANCE.info("User's file found : " + files.toString().trim());
    }

    @Override
    public void addExistingPlayer(String player) {
        this.existingPlayers.add(player);
    }

    @Override
    public ACPlayer createPlayer(String playername) {
        if (!this.existingPlayers.contains(playername)) {
            return new EmptyPlayer(playername);
        }
        if (this.directory != null) {
            return new FilePlayer(this.directory, playername);
        }
        return null;
    }

    @Override
    public ACPlayer createPlayer(Player player) {
        if (!this.existingPlayers.contains(player.getName())) {
            return new EmptyPlayer(player);
        }
        if (this.directory != null) {
            return new FilePlayer(this.directory, player);
        }
        return null;
    }

    @Override
    public Set<String> getExistingPlayers() {
        return this.existingPlayers;
    }
}

