/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Player;

import be.Balor.Manager.Exceptions.WorldNotLoaded;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.Configuration.ExConfigurationSection;
import be.Balor.Tools.Configuration.File.ExtendedConfiguration;
import be.Balor.Tools.Debug.ACLogger;
import be.Balor.Tools.Debug.DebugLog;
import be.Balor.Tools.Files.ObjectContainer;
import be.Balor.Tools.Help.String.Str;
import be.Balor.Tools.Threads.IOSaveTask;
import be.Balor.Tools.Type;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import belgium.Balor.Workers.InvisibleWorker;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class FilePlayer
extends ACPlayer {
    private final ExtendedConfiguration datas;
    private final ExConfigurationSection informations;
    private final ExConfigurationSection homes;
    private final ExConfigurationSection powers;
    private final ExConfigurationSection kitsUse;
    private final ExConfigurationSection lastLoc;
    private static final IOSaveTask IOSAVET_TASK = new IOSaveTask();
    private static int ioStackTaskId = -1;

    public FilePlayer(String directory, String name) {
        super(name);
        File pFile = new File(directory, name + ".yml");
        try {
            Files.createParentDirs((File)pFile);
        }
        catch (IOException e) {
            // empty catch block
        }
        this.datas = ExtendedConfiguration.loadConfiguration(pFile);
        this.informations = this.datas.addSection("infos");
        this.homes = this.datas.addSection("home");
        this.powers = this.datas.addSection("powers");
        this.kitsUse = this.datas.addSection("kitsUse");
        this.lastLoc = this.informations.addSection("lastLoc");
    }

    public FilePlayer(String directory, Player player) {
        super(player);
        File pFile = new File(directory, this.name + ".yml");
        try {
            Files.createParentDirs((File)pFile);
        }
        catch (IOException e) {
            // empty catch block
        }
        this.datas = ExtendedConfiguration.loadConfiguration(pFile);
        this.informations = this.datas.addSection("infos");
        this.homes = this.datas.addSection("home");
        this.powers = this.datas.addSection("powers");
        this.kitsUse = this.datas.addSection("kitsUse");
        this.lastLoc = this.informations.addSection("lastLoc");
    }

    public static void forceSaveList() {
        IOSAVET_TASK.run();
    }

    public static void scheduleAsyncSave() {
        if (ACPluginManager.getScheduler().isCurrentlyRunning(ioStackTaskId) || ACPluginManager.getScheduler().isQueued(ioStackTaskId)) {
            return;
        }
        int delay = ConfigEnum.WDELAY.getInt() >= 30 ? ConfigEnum.WDELAY.getInt() : 30;
        ioStackTaskId = ACPluginManager.getScheduler().scheduleAsyncRepeatingTask((Plugin)ACHelper.getInstance().getCoreInstance(), (Runnable)IOSAVET_TASK, 1200L, (long)(20 * delay));
        DebugLog.INSTANCE.info("IO Save RepeatingTask created : " + ioStackTaskId);
    }

    public static void stopSavingTask() {
        if (!ACPluginManager.getScheduler().isCurrentlyRunning(ioStackTaskId) && !ACPluginManager.getScheduler().isQueued(ioStackTaskId)) {
            return;
        }
        ACPluginManager.getScheduler().cancelTask(ioStackTaskId);
    }

    @Override
    public void setHome(String home, Location loc) {
        ExConfigurationSection homeToSet = this.homes.createSection(home);
        homeToSet.set("world", loc.getWorld().getName());
        homeToSet.set("x", loc.getX());
        homeToSet.set("y", loc.getY());
        homeToSet.set("z", loc.getZ());
        homeToSet.set("yaw", Float.valueOf(loc.getYaw()));
        homeToSet.set("pitch", Float.valueOf(loc.getPitch()));
        this.writeFile();
    }

    @Override
    public void removeHome(String home) {
        this.homes.set(home, null);
        this.writeFile();
    }

    @Override
    public Location getHome(String home) {
        ExConfigurationSection homeSection = this.homes.getConfigurationSection(home);
        if (homeSection == null) {
            String found = Str.matchString(this.homes.getKeys(false), home);
            if (found == null) {
                return null;
            }
            return this.getLocation(this.homes.getConfigurationSection(found));
        }
        return this.getLocation(homeSection);
    }

    @Override
    public void setInformation(String info, Object value) {
        this.informations.set(info, value);
        this.writeFile();
    }

    @Override
    public void removeInformation(String info) {
        this.informations.remove(info);
        this.writeFile();
    }

    @Override
    public ObjectContainer getInformation(String info) {
        Object infoObject = this.informations.get(info);
        return new ObjectContainer(infoObject);
    }

    @Override
    public void setLastLocation(Location loc) {
        if (loc == null) {
            return;
        }
        this.lastLoc.set("world", loc.getWorld().getName());
        this.lastLoc.set("x", loc.getX());
        this.lastLoc.set("y", loc.getY());
        this.lastLoc.set("z", loc.getZ());
        this.lastLoc.set("yaw", Float.valueOf(loc.getYaw()));
        this.lastLoc.set("pitch", Float.valueOf(loc.getPitch()));
        this.writeFile();
    }

    @Override
    public Location getLastLocation() {
        Location loc = this.getLocation(this.lastLoc);
        return loc;
    }

    private Location getLocation(ConfigurationSection node) throws WorldNotLoaded {
        World w = ACPluginManager.getServer().getWorld(node.getString("world"));
        if (w != null) {
            return new Location(w, node.getDouble("x", 0.0), node.getDouble("y", 0.0), node.getDouble("z", 0.0), Float.parseFloat(node.getString("yaw")), Float.parseFloat(node.getString("pitch")));
        }
        throw new WorldNotLoaded(node.getString("world"));
    }

    @Override
    public void setPower(Type power, Object value) {
        this.powers.set(power.toString(), value);
        this.writeFile();
    }

    @Override
    public ObjectContainer getPower(Type power) {
        Object result = this.powers.get(power.toString());
        return new ObjectContainer(result);
    }

    @Override
    public boolean hasPower(Type power) {
        boolean contain = false;
        contain = this.powers.contains(power.toString());
        return contain;
    }

    @Override
    public void removePower(Type power) {
        this.powers.set(power.toString(), null);
        this.writeFile();
    }

    @Override
    public Set<String> getHomeList() {
        HashSet<String> result = new HashSet();
        result = this.homes.getKeys(false);
        return result;
    }

    private void writeFile() {
        IOSAVET_TASK.addConfigurationToSave(this.datas);
    }

    @Override
    void forceSave() {
        try {
            IOSAVET_TASK.removeConfiguration(this.datas);
            this.datas.save();
        }
        catch (IOException e) {
            ACLogger.severe("Problem while saving Player file of " + this.getName(), e);
        }
    }

    @Override
    public void removeAllSuperPower() {
        for (String power : this.powers.getKeys(false)) {
            Type matched = Type.matchType(power);
            if (matched == null || !matched.getCategory().equals((Object)Type.Category.SUPER_POWER)) continue;
            this.powers.set(power, null);
            if (matched != Type.FLY || this.handler == null) continue;
            this.handler.setFlying(false);
            this.handler.setAllowFlight(false);
        }
        if (this.handler != null && InvisibleWorker.getInstance().hasInvisiblePowers(this.handler)) {
            InvisibleWorker.getInstance().reappear(this.handler);
        }
        this.writeFile();
    }

    @Override
    public void setCustomPower(String power, Object value) {
        Type.addCustomPower(power);
        this.powers.set(power, value);
        this.writeFile();
    }

    @Override
    public ObjectContainer getCustomPower(String power) {
        Object powerObject = this.powers.get(power);
        return new ObjectContainer(powerObject);
    }

    @Override
    public boolean hasCustomPower(String power) {
        return !this.getCustomPower(power).isNull();
    }

    @Override
    public void removeCustomPower(String power) {
        this.powers.set(power, null);
        this.writeFile();
    }

    @Override
    public Map<String, String> getPowers() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry entry : this.powers.getValues(false).entrySet()) {
            result.put((String)entry.getKey(), entry.getValue().toString());
        }
        return result;
    }

    @Override
    public long getLastKitUse(String kit) {
        long use = 0L;
        use = this.kitsUse.getLong(kit, 0L);
        return use;
    }

    @Override
    public void setPresentation(String presentation) {
        this.informations.set("presentation", presentation);
        this.writeFile();
    }

    @Override
    public String getPresentation() {
        String pres = "";
        pres = this.informations.getString("presentation", "");
        return pres;
    }

    @Override
    public Set<String> getInformationsList() {
        return this.informations.getKeys(false);
    }

    @Override
    public Set<String> getKitUseList() {
        return this.kitsUse.getKeys(false);
    }

    @Override
    public void setLastKitUse(String kit, long timestamp) {
        this.kitsUse.set(kit, timestamp);
        this.writeFile();
    }
}

