/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Player;

import be.Balor.Manager.Commands.ACCommandContainer;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Player.PlayerManager;
import be.Balor.Tools.Files.ObjectContainer;
import be.Balor.Tools.TpRequest;
import be.Balor.Tools.Type;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public abstract class ACPlayer {
    protected final String name;
    private final int hashCode;
    protected boolean online = false;
    protected ACCommandContainer lastCmd = null;
    protected Player handler = null;
    protected TpRequest tpRequest = null;

    protected ACPlayer(String name) {
        this.name = name;
        int prime = 41;
        int result = 7;
        this.hashCode = result = 41 * result + (this.name == null ? 0 : this.name.hashCode());
        this.handler = ACPluginManager.getServer().getPlayer(this.name);
    }

    protected ACPlayer(Player p) {
        this.name = p.getName();
        int prime = 41;
        int result = 7;
        this.hashCode = result = 41 * result + (this.name == null ? 0 : this.name.hashCode());
        this.handler = p;
    }

    public static synchronized ACPlayer getPlayer(String name) {
        return PlayerManager.getInstance().demandACPlayer(name);
    }

    public static synchronized ACPlayer getPlayer(Player player) {
        return PlayerManager.getInstance().demandACPlayer(player);
    }

    public static List<ACPlayer> getPlayers(Type power) {
        return PlayerManager.getInstance().getACPlayerHavingPower(power);
    }

    public static List<ACPlayer> getPlayers(String power) {
        return PlayerManager.getInstance().getACPlayerHavingPower(power);
    }

    public Player getHandler() {
        return this.handler;
    }

    public String getName() {
        return this.name;
    }

    public abstract void setHome(String var1, Location var2);

    public abstract void removeHome(String var1);

    public abstract Location getHome(String var1);

    public abstract Set<String> getHomeList();

    public abstract void setInformation(String var1, Object var2);

    public abstract void removeInformation(String var1);

    public abstract ObjectContainer getInformation(String var1);

    public abstract Set<String> getInformationsList();

    public abstract void setLastLocation(Location var1);

    public abstract Location getLastLocation();

    public void setPower(Type power) {
        this.setPower(power, true);
    }

    public abstract void setPower(Type var1, Object var2);

    public void setCustomPower(String power) {
        this.setCustomPower(power, true);
    }

    public abstract void setCustomPower(String var1, Object var2);

    public abstract ObjectContainer getCustomPower(String var1);

    public abstract boolean hasCustomPower(String var1);

    public abstract void removeCustomPower(String var1);

    public abstract ObjectContainer getPower(Type var1);

    public abstract boolean hasPower(Type var1);

    public abstract void removePower(Type var1);

    public abstract void removeAllSuperPower();

    public void updateLastKitUse(String kit) {
        this.setLastKitUse(kit, System.currentTimeMillis());
    }

    public abstract void setLastKitUse(String var1, long var2);

    public abstract long getLastKitUse(String var1);

    public abstract Set<String> getKitUseList();

    abstract void forceSave();

    public void updatePlayedTime() {
        this.setInformation("totalTime", this.getCurrentPlayedTime());
    }

    public abstract Map<String, String> getPowers();

    public long getCurrentPlayedTime() {
        return this.getInformation("totalTime").getLong(0L) + System.currentTimeMillis() - this.getInformation("lastConnection").getLong(System.currentTimeMillis());
    }

    public abstract void setPresentation(String var1);

    public abstract String getPresentation();

    void setOnline(boolean isOnline) {
        this.online = isOnline;
        if (!this.online) {
            this.handler = null;
        } else if (this.handler == null) {
            this.handler = ACPluginManager.getServer().getPlayer(this.name);
        }
    }

    public void setLastCmd(ACCommandContainer lastCmd) {
        this.lastCmd = lastCmd;
    }

    public void executeLastCmd() throws NullPointerException, PlayerNotFound {
        if (this.lastCmd == null) {
            throw new NullPointerException();
        }
        try {
            this.lastCmd.execute();
        }
        catch (ActionNotPermitedException e) {
            e.sendMessage();
        }
    }

    public void setTpRequest(TpRequest tpRequest) {
        this.tpRequest = tpRequest;
    }

    public TpRequest getTpRequest() {
        return this.tpRequest;
    }

    public void removeTpRequest() {
        this.tpRequest = null;
    }

    public boolean isOnline() {
        return this.online;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ACPlayer)) {
            return false;
        }
        ACPlayer other = (ACPlayer)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

