/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Permissions.Plugins;

import be.Balor.Manager.Exceptions.NoPermissionsPlugin;
import be.Balor.Manager.Permissions.Group;
import be.Balor.Manager.Permissions.Plugins.SuperPermissions;
import be.Balor.Tools.Utils;
import de.bananaco.bpermissions.api.ApiLayer;
import de.bananaco.bpermissions.api.util.CalculableType;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.entity.Player;

public class bPermissions
extends SuperPermissions {
    @Override
    public boolean isInGroup(String groupName, Player player) {
        String[] groups = ApiLayer.getGroups((String)player.getWorld().getName(), (CalculableType)CalculableType.USER, (String)player.getName());
        if (groups == null) {
            return false;
        }
        if (groups.length == 0) {
            return false;
        }
        for (String group : groups) {
            if (!group.equalsIgnoreCase(groupName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Player> getUsers(String groupName) throws NoPermissionsPlugin {
        HashSet<Player> players = new HashSet<Player>();
        for (Player player : Utils.getOnlinePlayers()) {
            if (!ApiLayer.hasGroup((String)player.getWorld().getName(), (CalculableType)CalculableType.USER, (String)player.getName(), (String)groupName)) continue;
            players.add(player);
        }
        return players;
    }

    @Override
    public String getPermissionLimit(Player p, String limit) {
        String result = ApiLayer.getValue((String)p.getWorld().getName(), (CalculableType)CalculableType.USER, (String)p.getName(), (String)limit);
        if (result == null || result != null && result.isEmpty()) {
            result = super.getPermissionLimit(p, limit);
        }
        return result;
    }

    @Override
    public String getPrefix(Player player) {
        String prefix = super.getPrefix(player);
        if (prefix == null || prefix.isEmpty()) {
            prefix = ApiLayer.getValue((String)player.getWorld().getName(), (CalculableType)CalculableType.USER, (String)player.getName(), (String)"prefix");
        }
        return prefix;
    }

    @Override
    public String getSuffix(Player player) {
        String suffix = super.getSuffix(player);
        if (suffix == null || suffix.isEmpty()) {
            suffix = ApiLayer.getValue((String)player.getWorld().getName(), (CalculableType)CalculableType.USER, (String)player.getName(), (String)"suffix");
        }
        return suffix;
    }

    @Override
    public Group getGroup(Player player) {
        String[] groups = ApiLayer.getGroups((String)player.getWorld().getName(), (CalculableType)CalculableType.USER, (String)player.getName());
        if (groups.length == 0) {
            return new Group();
        }
        int maxPriority = Integer.MIN_VALUE;
        String bestGroup = groups[0];
        for (String group : groups) {
            try {
                int currentPriority = Integer.parseInt(ApiLayer.getValue((String)player.getWorld().getName(), (CalculableType)CalculableType.GROUP, (String)group, (String)"priority"));
                if (currentPriority <= maxPriority) continue;
                maxPriority = currentPriority;
                bestGroup = group;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String priority = ApiLayer.getValue((String)player.getWorld().getName(), (CalculableType)CalculableType.USER, (String)player.getName(), (String)"priority");
        return new Group(bestGroup, priority == null || priority != null && priority.isEmpty() ? 0 : Integer.parseInt(priority));
    }
}

