/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Permissions.Plugins;

import be.Balor.Manager.Exceptions.NoPermissionsPlugin;
import be.Balor.Manager.Permissions.Group;
import be.Balor.Manager.Permissions.Plugins.IPermissionPlugin;
import be.Balor.Tools.Utils;
import com.nijiko.permissions.PermissionHandler;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;

public class YetiPermissions
implements IPermissionPlugin {
    protected PermissionHandler permission = null;

    public YetiPermissions(PermissionHandler perm) {
        this.permission = perm;
    }

    public PermissionHandler getPermission() {
        return this.permission;
    }

    @Override
    public boolean hasPerm(CommandSender player, String perm, boolean errorMsg) {
        if (!(player instanceof Player)) {
            return true;
        }
        if (this.permission.has((Player)player, perm)) {
            return true;
        }
        if (errorMsg) {
            Utils.sI18n(player, "errorNotPerm", "p", perm);
        }
        return false;
    }

    @Override
    public boolean hasPerm(CommandSender player, Permission perm, boolean errorMsg) {
        if (!(player instanceof Player)) {
            return true;
        }
        if (this.permission.has((Player)player, perm.getName())) {
            return true;
        }
        if (errorMsg) {
            Utils.sI18n(player, "errorNotPerm", "p", perm.getName());
        }
        return false;
    }

    @Override
    public boolean isInGroup(String groupName, Player player) {
        return this.permission.inGroup(player.getWorld().getName(), player.getName(), groupName);
    }

    @Override
    public Set<Player> getUsers(String groupName) throws NoPermissionsPlugin {
        throw new NoPermissionsPlugin("To use this functionality you need a newer Permissions plugin!");
    }

    @Override
    public String getPermissionLimit(Player p, String type) {
        Integer limitInteger = null;
        try {
            limitInteger = this.permission.getInfoInteger(p.getWorld().getName(), p.getName(), "admincmd." + type, false);
        }
        catch (NoSuchMethodError e) {
            try {
                limitInteger = this.permission.getPermissionInteger(p.getWorld().getName(), p.getName(), "admincmd." + type);
            }
            catch (Throwable e2) {
                limitInteger = null;
            }
        }
        if (limitInteger != null && limitInteger != -1) {
            return limitInteger.toString();
        }
        return null;
    }

    @Override
    public String getPrefix(Player player) {
        String world = player.getWorld().getName();
        String pName = player.getName();
        String prefixstring = null;
        try {
            prefixstring = this.permission.safeGetUser(world, pName).getPrefix();
        }
        catch (Exception e) {
            String group = this.permission.getGroup(world, pName);
            prefixstring = this.permission.getGroupPrefix(world, group);
        }
        catch (NoSuchMethodError e) {
            String group = this.permission.getGroup(world, pName);
            prefixstring = this.permission.getGroupPrefix(world, group);
        }
        return prefixstring;
    }

    @Override
    public String getSuffix(Player player) {
        String world = player.getWorld().getName();
        String pName = player.getName();
        String prefixstring = null;
        try {
            prefixstring = this.permission.safeGetUser(world, pName).getSuffix();
        }
        catch (Exception e) {
            String group = this.permission.getGroup(world, pName);
            prefixstring = this.permission.getGroupSuffix(world, group);
        }
        catch (NoSuchMethodError e) {
            String group = this.permission.getGroup(world, pName);
            prefixstring = this.permission.getGroupSuffix(world, group);
        }
        return prefixstring;
    }

    @Override
    public Group getGroup(Player player) {
        return new Group();
    }
}

