/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Permissions.Plugins;

import be.Balor.Manager.Exceptions.NoPermissionsPlugin;
import be.Balor.Manager.Permissions.Plugins.IPermissionPlugin;
import be.Balor.Tools.Utils;
import com.miraclem4n.mchat.api.Reader;
import in.mDev.MiracleM4n.mChatSuite.mChatSuite;
import in.mDev.MiracleM4n.mChatSuite.types.InfoType;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachmentInfo;

public abstract class SuperPermissions
implements IPermissionPlugin {
    private static boolean mChat = false;

    public static void setmChatapi(mChatSuite mChatSuite2) {
        if (!mChat && mChatSuite2 != null) {
            mChat = true;
        }
    }

    public static boolean isApiSet() {
        return mChat;
    }

    @Override
    public boolean hasPerm(CommandSender player, String perm, boolean errorMsg) {
        if (!(player instanceof Player)) {
            return true;
        }
        if (player.hasPermission(perm)) {
            return true;
        }
        if (errorMsg) {
            Utils.sI18n(player, "errorNotPerm", "p", perm);
        }
        return false;
    }

    @Override
    public boolean hasPerm(CommandSender player, Permission perm, boolean errorMsg) {
        if (!(player instanceof Player)) {
            return true;
        }
        if (player.hasPermission(perm)) {
            return true;
        }
        if (errorMsg) {
            Utils.sI18n(player, "errorNotPerm", "p", perm.getName());
        }
        return false;
    }

    @Override
    public boolean isInGroup(String group, Player player) throws NoPermissionsPlugin {
        throw new NoPermissionsPlugin("To use this functionality you need a Permission Plugin");
    }

    @Override
    public Set<Player> getUsers(String groupName) throws NoPermissionsPlugin {
        throw new NoPermissionsPlugin("To use this functionality you need a Permission Plugin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPermissionLimit(Player p, String limit) {
        String result = null;
        if (mChat) {
            result = Reader.getInfo((String)p.getName(), (InfoType)InfoType.USER, (String)p.getWorld().getName(), (String)("admincmd." + limit));
        }
        if (result == null || result != null && result.isEmpty()) {
            Pattern regex = Pattern.compile("admincmd\\." + limit.toLowerCase() + "\\.[0-9]+");
            Set perms = p.getEffectivePermissions();
            int max = Integer.MIN_VALUE;
            Set set = perms;
            synchronized (set) {
                for (PermissionAttachmentInfo info : perms) {
                    int current;
                    Matcher regexMatcher = regex.matcher(info.getPermission().toLowerCase());
                    if (!regexMatcher.find() || (current = Integer.parseInt(info.getPermission().split("\\.")[2])) < max) continue;
                    max = current;
                }
            }
            if (max != Integer.MIN_VALUE) {
                return String.valueOf(max);
            }
        } else {
            return result;
        }
        return null;
    }

    @Override
    public String getPrefix(Player player) {
        if (mChat) {
            return Reader.getPrefix((String)player.getName(), (InfoType)InfoType.USER, (String)player.getWorld().getName());
        }
        return "";
    }

    @Override
    public String getSuffix(Player player) {
        if (mChat) {
            return Reader.getSuffix((String)player.getName(), (InfoType)InfoType.USER, (String)player.getWorld().getName());
        }
        return "";
    }
}

