/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Permissions;

import be.Balor.Manager.Exceptions.NoPermissionsPlugin;
import be.Balor.Manager.Permissions.Group;
import be.Balor.Manager.Permissions.PermissionLinker;
import be.Balor.Manager.Permissions.Plugins.BukkitPermissions;
import be.Balor.Manager.Permissions.Plugins.DinnerPermissions;
import be.Balor.Manager.Permissions.Plugins.EssentialsGroupManager;
import be.Balor.Manager.Permissions.Plugins.IPermissionPlugin;
import be.Balor.Manager.Permissions.Plugins.PermissionsEx;
import be.Balor.Manager.Permissions.Plugins.YetiPermissions;
import be.Balor.Manager.Permissions.Plugins.bPermissions;
import be.Balor.Tools.Debug.ACLogger;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import com.nijiko.permissions.PermissionHandler;
import com.platymuus.bukkit.permissions.PermissionsPlugin;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;

public class PermissionManager {
    private static PermissionManager instance = null;
    private static boolean permissionsEx = false;
    private static boolean yetiPermissions = false;
    private static boolean bPermissions = false;
    private static boolean permissionsBukkit = false;
    private static boolean groupManager = false;
    private static IPermissionPlugin permissionHandler;
    private static boolean warningSend;
    private final Hashtable<String, WeakReference<PermissionLinker>> permissionLinkers = new Hashtable();

    public static PermissionManager getInstance() {
        if (instance == null) {
            instance = new PermissionManager();
        }
        return instance;
    }

    public static String getPermissionLimit(Player p, String limit) {
        return permissionHandler.getPermissionLimit(p, limit);
    }

    public static String getPrefix(Player player) {
        return permissionHandler.getPrefix(player);
    }

    public static String getSuffix(Player player) {
        return permissionHandler.getSuffix(player);
    }

    public static Group getGroup(Player player) {
        return permissionHandler.getGroup(player);
    }

    public static boolean hasPerm(CommandSender player, Permission perm) throws NullPointerException {
        return PermissionManager.hasPerm(player, perm, true);
    }

    public static boolean hasPerm(CommandSender player, Permission perm, boolean errorMsg) throws NullPointerException {
        if (perm == null) {
            throw new NullPointerException("The Permission Node can't be NULL");
        }
        if (player == null) {
            throw new NullPointerException("The CommandSender can't be NULL");
        }
        return permissionHandler.hasPerm(player, perm, errorMsg);
    }

    public static boolean hasPerm(CommandSender player, String perm) throws NullPointerException {
        return PermissionManager.hasPerm(player, perm, true);
    }

    public static boolean hasPerm(CommandSender player, String perm, boolean errorMsg) throws NullPointerException {
        if (perm == null) {
            throw new NullPointerException("The Permission Node can't be NULL");
        }
        if (player == null) {
            throw new NullPointerException("The CommandSender can't be NULL");
        }
        return permissionHandler.hasPerm(player, perm, errorMsg);
    }

    public static boolean isbPermissionsSet() {
        return bPermissions;
    }

    public static boolean isInGroup(String groupName, Player player) throws NoPermissionsPlugin {
        return permissionHandler.isInGroup(groupName, player);
    }

    public static boolean isPermissionsBukkitSet() {
        return permissionsBukkit;
    }

    public static boolean isPermissionsExSet() {
        return permissionsEx;
    }

    public static boolean isYetiPermissionsSet() {
        return yetiPermissions;
    }

    public static boolean isGroupManagerSet() {
        return groupManager;
    }

    public static boolean setbPermissions() {
        if (!(bPermissions || permissionsEx || groupManager)) {
            bPermissions = true;
            permissionHandler = new bPermissions();
            if (!yetiPermissions) {
                ACLogger.info("Successfully linked with bPermissions.");
            } else {
                ACLogger.info("Successfully linked with bPermissions overpassing the Permission Bridge.");
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean setPermissionsBukkit(PermissionsPlugin plugin) {
        if (!(permissionsBukkit || bPermissions || permissionsEx || groupManager)) {
            permissionsBukkit = true;
            permissionHandler = new BukkitPermissions(plugin);
            if (!yetiPermissions) {
                ACLogger.info("Successfully linked with PermissionsBukkit.");
            } else {
                ACLogger.info("Successfully linked with PermissionsBukkit overpassing the Permission Bridge.");
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean setPEX(ru.tehkode.permissions.PermissionManager pEX) {
        if (!permissionsEx) {
            if (!ConfigEnum.SUPERPERM.getBoolean()) {
                permissionsEx = true;
                permissionHandler = new PermissionsEx(pEX);
                if (!yetiPermissions) {
                    ACLogger.info("Successfully linked with PermissionsEX");
                } else {
                    ACLogger.info("Use PermissionsEX instead of Yeti's Permissions.");
                }
            } else if (!warningSend) {
                ACLogger.info("Plugin Forced to use Offical Bukkit Permission System");
                warningSend = true;
            }
            return true;
        }
        return false;
    }

    public static boolean setYetiPermissions(PermissionHandler plugin) {
        if (!(yetiPermissions || permissionsEx || groupManager)) {
            if (!ConfigEnum.SUPERPERM.getBoolean()) {
                yetiPermissions = true;
                permissionHandler = new YetiPermissions(plugin);
                ACLogger.info("Successfully linked with Yeti's Permissions.");
            } else if (!warningSend) {
                ACLogger.info("Plugin Forced to use Offical Bukkit Permission System");
                warningSend = true;
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean setGroupManager(Plugin plugin) {
        if (!groupManager && !permissionsEx) {
            if (!ConfigEnum.SUPERPERM.getBoolean()) {
                groupManager = true;
                permissionHandler = new EssentialsGroupManager(plugin);
                if (!yetiPermissions) {
                    ACLogger.info("Successfully linked with Essantials GroupManager");
                } else {
                    ACLogger.info("Use Essantials GroupManager instead of Yeti's Permissions.");
                }
            } else if (!warningSend) {
                ACLogger.info("Plugin Forced to use Offical Bukkit Permission System");
                warningSend = true;
            }
        } else {
            return false;
        }
        return true;
    }

    private PermissionManager() {
        if (permissionHandler == null) {
            permissionHandler = new DinnerPermissions();
        }
    }

    public synchronized boolean addPermissionLinker(PermissionLinker perm) {
        String name = perm.getName();
        if (name == null) {
            throw new NullPointerException();
        }
        WeakReference<PermissionLinker> ref = this.permissionLinkers.get(name);
        if (ref != null) {
            if (ref.get() == null) {
                this.permissionLinkers.remove(name);
            } else {
                return false;
            }
        }
        this.permissionLinkers.put(name, new WeakReference<PermissionLinker>(perm));
        return true;
    }

    PermissionLinker demandPermissionLinker(String name) {
        PermissionLinker result = this.getPermissionLinker(name);
        if (result == null) {
            result = new PermissionLinker(name);
            this.addPermissionLinker(result);
            result = this.getPermissionLinker(name);
        }
        return result;
    }

    public synchronized PermissionLinker getPermissionLinker(String name) {
        WeakReference<PermissionLinker> ref = this.permissionLinkers.get(name);
        if (ref == null) {
            return null;
        }
        PermissionLinker perm = (PermissionLinker)ref.get();
        if (perm == null) {
            this.permissionLinkers.remove(name);
        }
        return perm;
    }

    static {
        warningSend = false;
    }
}

