/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Permissions;

import be.Balor.Manager.Permissions.PermChild;
import be.Balor.Manager.Permissions.PermParent;
import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Tools.Debug.DebugLog;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public class PermissionLinker {
    protected Map<String, PermParent> permissions = new HashMap<String, PermParent>();
    protected Map<String, PermParent> childrenPermParents = new HashMap<String, PermParent>();
    protected PermParent majorPerm;
    protected String name;
    private static int counter = 0;
    private final int plId = counter++;

    public static Permission addOnTheFly(String permNode, String parentNode) {
        if (ACPluginManager.getServer() == null) {
            return null;
        }
        Permission child = ACPluginManager.getServer().getPluginManager().getPermission(permNode);
        if (child == null) {
            child = new Permission(permNode, PermissionDefault.OP);
            ACPluginManager.getServer().getPluginManager().addPermission(child);
            if (parentNode.isEmpty()) {
                return child;
            }
            Permission parent = ACPluginManager.getServer().getPluginManager().getPermission(parentNode);
            if (parent == null) {
                parent = new Permission(parentNode, PermissionDefault.OP);
                ACPluginManager.getServer().getPluginManager().addPermission(parent);
            }
            child.addParent(parent, true);
        }
        return child;
    }

    public static synchronized PermissionLinker getPermissionLinker(String name) {
        return PermissionManager.getInstance().demandPermissionLinker(name);
    }

    protected PermissionLinker(String name) {
        this.name = name;
    }

    public Permission addPermChild(String permNode) {
        return this.addPermChild(permNode, PermissionDefault.OP);
    }

    public Permission addPermChild(String permNode, PermissionDefault bukkitDefault) throws NullPointerException {
        PermParent parent = this.matchPermParent(permNode);
        PermChild child = new PermChild(permNode, bukkitDefault);
        if (parent == null) {
            DebugLog.INSTANCE.info("No Permission Parent found for : " + permNode);
            return child.getBukkitPerm();
        }
        parent.addChild(child);
        DebugLog.INSTANCE.info(child + " registered as child of " + parent);
        return child.getBukkitPerm();
    }

    public void addPermParent(PermParent toAdd) {
        this.permissions.put(toAdd.getPermName(), toAdd);
    }

    public void addPermParent(String toAdd) {
        PermParent pp = new PermParent(toAdd);
        this.permissions.put(pp.getPermName(), pp);
    }

    public PermParent addChildPermParent(PermParent toAdd, PermParent parent) {
        parent.addChild(toAdd);
        this.childrenPermParents.put(toAdd.getPermName(), toAdd);
        return toAdd;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionLinker)) {
            return false;
        }
        PermissionLinker other = (PermissionLinker)obj;
        if (this.majorPerm == null ? other.majorPerm != null : !this.majorPerm.equals(other.majorPerm)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.plId == other.plId;
    }

    public String getName() {
        return this.name;
    }

    public PermParent getPermParent(String permNode) {
        PermParent result = this.permissions.get(permNode);
        if (result == null) {
            result = this.childrenPermParents.get(permNode);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.majorPerm == null ? 0 : this.majorPerm.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.plId;
        return result;
    }

    private PermParent matchPermParent(String search) {
        PermParent found = null;
        String lowerSearch = search.toLowerCase();
        int delta = Integer.MAX_VALUE;
        HashSet<PermParent> values = new HashSet<PermParent>();
        values.addAll(this.permissions.values());
        values.addAll(this.childrenPermParents.values());
        for (PermParent perm : values) {
            String str = perm.getCompareName();
            if (!lowerSearch.toLowerCase().startsWith(str)) continue;
            int curDelta = lowerSearch.length() - str.length();
            if (curDelta < delta) {
                found = perm;
                delta = curDelta;
            }
            if (curDelta != 0) continue;
            break;
        }
        return found;
    }

    public void registerAllPermParent() {
    }

    public void setMajorPerm(PermParent major) {
        this.majorPerm = major;
        for (PermParent pp : this.permissions.values()) {
            this.majorPerm.addChild(pp);
        }
    }

    public void setMajorPerm(String major) {
        this.majorPerm = new PermParent(major);
        for (PermParent pp : this.permissions.values()) {
            this.majorPerm.addChild(pp);
        }
    }

    public String toString() {
        return "PermissionLinker [majorPerm=" + this.majorPerm + ", name=" + this.name + ", plId=" + this.plId + "]";
    }

    public PermParent getMajorPerm() {
        return this.majorPerm;
    }
}

