/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager;

import be.Balor.Tools.Configuration.File.ExtendedConfiguration;
import be.Balor.Tools.Debug.ACLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.bukkit.configuration.InvalidConfigurationException;

public class LocaleManager {
    private static LocaleManager instance = new LocaleManager();
    private final Map<String, ExtendedConfiguration> localesFiles = new HashMap<String, ExtendedConfiguration>();
    public static final String PRIMARY_LOCALE = "primary";
    private boolean noMsg = false;
    private final Pattern recursiveLocale = Pattern.compile("#([\\w]+)#");
    private final Pattern replaceLocale = Pattern.compile("%([\\w]+)");
    private final Pattern buggedLocale = Pattern.compile("\\?(\\w)");

    public static LocaleManager getInstance() {
        return instance;
    }

    public void setNoMsg(boolean noMsg) {
        this.noMsg = noMsg;
    }

    public void addLocaleFile(String name, File file) {
        this.localesFiles.put(name, ExtendedConfiguration.loadConfiguration(file));
    }

    public void save() {
        try {
            for (ExtendedConfiguration conf : this.localesFiles.values()) {
                conf.save();
            }
        }
        catch (Exception e) {
            ACLogger.severe("Problem while saving locale file", e);
        }
    }

    public void addLocale(String key, String value) {
        this.addLocale(key, value, false);
    }

    public void addLocale(String key, String value, boolean override) {
        if (override) {
            this.localesFiles.get(PRIMARY_LOCALE).set(key, value);
        } else {
            this.localesFiles.get(PRIMARY_LOCALE).add(key, value);
        }
    }

    public boolean addLocale(String file, String key, String value, boolean override) {
        ExtendedConfiguration conf = this.localesFiles.get(file);
        if (conf == null) {
            return false;
        }
        if (override) {
            conf.set(key, value);
            return true;
        }
        return conf.add(key, value);
    }

    public boolean addLocale(String file, String key, String value) {
        return this.addLocale(file, key, value, false);
    }

    public String get(String key) {
        return this.get(key, null);
    }

    public String get(String key, Map<String, String> values) {
        if (this.noMsg) {
            return null;
        }
        String locale = this.getLocale(key);
        if (locale != null && values != null) {
            locale = this.recursiveReplaceLocale(locale, values);
        }
        return locale;
    }

    public String get(String file, String key, Map<String, String> values) {
        if (this.noMsg) {
            return null;
        }
        String locale = this.getLocale(file, key);
        if (locale != null && values != null) {
            locale = this.recursiveReplaceLocale(locale, values);
        }
        return locale;
    }

    private String getLocale(String file, String key) {
        ExtendedConfiguration ex = this.localesFiles.get(file);
        if (ex == null) {
            return null;
        }
        return ex.getString(key);
    }

    private String getLocale(String key) {
        String result;
        block1: {
            result = this.localesFiles.get(PRIMARY_LOCALE).getString(key);
            if (result != null && (result == null || !result.isEmpty())) break block1;
            for (Map.Entry<String, ExtendedConfiguration> e : this.localesFiles.entrySet()) {
                if (!e.getKey().equals(PRIMARY_LOCALE) && (result = e.getValue().getString(key)) != null && !result.isEmpty()) break;
            }
        }
        return result;
    }

    private String recursiveReplaceLocale(String locale, Map<String, String> values) {
        Matcher regexMatcher;
        String ResultString = null;
        String result = locale;
        try {
            regexMatcher = this.recursiveLocale.matcher(locale);
            while (regexMatcher.find()) {
                ResultString = regexMatcher.group(1);
                String recLocale = this.getLocale(ResultString);
                result = recLocale != null ? regexMatcher.replaceFirst(recLocale) : regexMatcher.replaceFirst("");
                regexMatcher = this.recursiveLocale.matcher(result);
            }
            regexMatcher = this.replaceLocale.matcher(result);
            while (regexMatcher.find()) {
                ResultString = regexMatcher.group(1);
                String replaceValue = values.get(ResultString);
                if (replaceValue != null) {
                    try {
                        result = regexMatcher.replaceFirst(replaceValue);
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        result = regexMatcher.replaceFirst(replaceValue.replaceAll("\\W", ""));
                    }
                } else {
                    result = regexMatcher.replaceFirst("");
                }
                regexMatcher = this.replaceLocale.matcher(result);
            }
        }
        catch (PatternSyntaxException ex) {
            // empty catch block
        }
        regexMatcher = this.buggedLocale.matcher(result);
        result = regexMatcher.replaceAll("\u00c2\u00a7$1");
        return result;
    }

    public String get(String key, String alias, String replaceBy) {
        if (this.noMsg) {
            return null;
        }
        String locale = this.getLocale(key);
        if (locale != null && alias != null) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put(alias, replaceBy);
            locale = this.recursiveReplaceLocale(locale, replace);
        }
        return locale;
    }

    public String get(String file, String key, String alias, String replaceBy) {
        if (this.noMsg) {
            return null;
        }
        String locale = this.getLocale(file, key);
        if (locale != null && alias != null) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put(alias, replaceBy);
            locale = this.recursiveReplaceLocale(locale, replace);
        }
        return locale;
    }

    public Set<String> getKeys() {
        HashSet<String> locales = new HashSet<String>();
        for (ExtendedConfiguration exConf : this.localesFiles.values()) {
            locales.addAll(exConf.getKeys(false));
        }
        return locales;
    }

    public void reload() {
        try {
            for (ExtendedConfiguration exConf : this.localesFiles.values()) {
                exConf.reload();
            }
        }
        catch (FileNotFoundException e) {
            ACLogger.severe("Locale Reload Problem :", e);
        }
        catch (IOException e) {
            ACLogger.severe("Locale Reload Problem :", e);
        }
        catch (InvalidConfigurationException e) {
            ACLogger.severe("Locale Reload Problem :", e);
        }
    }
}

