/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Weather;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Weather.WeatherCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.Threads.RemovePowerTask;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Thor
extends WeatherCommand {
    public Thor() {
        this.permNode = "admincmd.weather.thor";
        this.cmdName = "bal_thor";
        this.other = true;
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        Player player = Utils.getUser(sender, args, this.permNode);
        String timeOut = args.getValueFlag('t');
        if (player != null) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("player", Utils.getPlayerName(player));
            ACPlayer acp = ACPlayer.getPlayer(player.getName());
            if (acp.hasPower(Type.THOR)) {
                acp.removePower(Type.THOR);
                Utils.sI18n((CommandSender)player, "thorDisabled");
                if (!player.equals(sender)) {
                    Utils.sI18n(sender, "thorDisabledTarget", replace);
                }
            } else {
                int timeOutValue;
                acp.setPower(Type.THOR);
                Utils.sI18n((CommandSender)player, "thorEnabled");
                if (!player.equals(sender)) {
                    Utils.sI18n(sender, "thorEnabledTarget", replace);
                }
                if (timeOut == null) {
                    return;
                }
                try {
                    timeOutValue = Integer.parseInt(timeOut);
                }
                catch (Exception e) {
                    Utils.sI18n(sender, "NaN", "number", timeOut);
                    return;
                }
                ACPluginManager.getScheduler().scheduleAsyncDelayedTask((Plugin)ACPluginManager.getCorePlugin(), (Runnable)new RemovePowerTask(acp, Type.THOR, sender), (long)(20 * ConfigEnum.SCALE_TIMEOUT.getInt() * timeOutValue));
            }
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }
}

