/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Tp;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Tp.TeleportCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.Threads.RemovePowerTask;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TpAtSee
extends TeleportCommand {
    public TpAtSee() {
        this.permNode = "admincmd.tp.see";
        this.cmdName = "bal_tpsee";
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        String timeOut = args.getValueFlag('t');
        if (Utils.isPlayer(sender)) {
            Player player = (Player)sender;
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("player", Utils.getPlayerName(player));
            ACPlayer acp = ACPlayer.getPlayer(player.getName());
            if (acp.hasPower(Type.TP_AT_SEE)) {
                acp.removePower(Type.TP_AT_SEE);
                Utils.sI18n((CommandSender)player, "tpSeeDisabled");
            } else {
                int timeOutValue;
                acp.setPower(Type.TP_AT_SEE);
                Utils.sI18n((CommandSender)player, "tpSeeEnabled");
                if (timeOut == null) {
                    return;
                }
                try {
                    timeOutValue = Integer.parseInt(timeOut);
                }
                catch (Exception e) {
                    Utils.sI18n(sender, "NaN", "number", timeOut);
                    return;
                }
                ACPluginManager.getScheduler().scheduleAsyncDelayedTask((Plugin)ACPluginManager.getCorePlugin(), (Runnable)new RemovePowerTask(acp, Type.TP_AT_SEE, sender), (long)(20 * ConfigEnum.SCALE_TIMEOUT.getInt() * timeOutValue));
            }
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return true;
    }
}

