/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Tp;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Tp.TeleportCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.Utils;
import be.Balor.Tools.Warp;
import be.Balor.World.ACWorld;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.LocaleHelper;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TpAll
extends TeleportCommand {
    public TpAll() {
        this.cmdName = "bal_tpall";
        this.permNode = "admincmd.tp.all";
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws PlayerNotFound, ActionNotPermitedException {
        ACWorld world;
        Player[] players = ACPluginManager.getServer().getOnlinePlayers();
        HashMap<String, String> replace = new HashMap<String, String>();
        String teleporter = Utils.isPlayer(sender, false) ? Utils.getPlayerName((Player)sender) : "Admin";
        if (args.length == 2) {
            world = ACWorld.getWorld(args.getString(0));
        } else if (args.length >= 4) {
            world = ACWorld.getWorld(args.getString(0));
        } else if (sender instanceof Player) {
            world = ACWorld.getWorld(((Player)sender).getWorld().getName());
        } else {
            replace.put("arg", "world");
            replace.put("cmdName", "/tpall");
            LocaleHelper.MISSING_ARG.sendLocale(sender, replace);
            return;
        }
        if (world == null) {
            replace.put("world", args.getString(0));
            Utils.sI18n(sender, "worldNotFound", replace);
            return;
        }
        Location to = null;
        if (args.hasFlag('s')) {
            to = world.getSpawn();
            replace.put("sender", teleporter);
            replace.put("loc", "the Spawn of " + world.getName());
            this.doTeleportAndMessage(players, replace, to);
        } else if (args.hasFlag('w')) {
            String value = args.getValueFlag('w');
            if (value == null) {
                return;
            }
            Warp w = world.getWarp(value);
            if (w == null) {
                replace.clear();
                replace.put("name", value);
                Utils.sI18n(sender, "errorWarp", replace);
                return;
            }
            to = w.loc;
            replace.put("sender", teleporter);
            replace.put("loc", w.name);
            this.doTeleportAndMessage(players, replace, to);
        } else if (args.hasFlag('p')) {
            String value = args.getValueFlag('p');
            ACPlayer target = ACPlayer.getPlayer(value);
            if (target == null) {
                replace.clear();
                replace.put("player", value);
                Utils.sI18n(sender, "playerNotFound", replace);
                return;
            }
            to = target.getHandler().getLocation();
            replace.put("sender", teleporter);
            replace.put("loc", Utils.getPlayerName(target.getHandler()));
            this.doTeleportAndMessage(players, replace, to);
        } else if (args.hasFlag('l')) {
            String z;
            String y;
            String x;
            if (args.length == 3) {
                x = args.getString(0);
                y = args.getString(1);
                z = args.getString(2);
            } else if (args.length > 3) {
                x = args.getString(1);
                y = args.getString(2);
                z = args.getString(3);
            } else {
                replace.clear();
                replace.put("cmdName", "/tpall");
                replace.put("arg", "Location in x,y,z coordinates");
                LocaleHelper.MISSING_ARG.sendLocale(sender, replace);
                return;
            }
            Double locX = null;
            Double locY = null;
            Double locZ = null;
            this.parseNumber(sender, x, locX);
            this.parseNumber(sender, y, locY);
            this.parseNumber(sender, z, locZ);
            if (locX == null || locY == null || locZ == null) {
                return;
            }
            to = new Location(world.getHandler(), locX.doubleValue(), locY.doubleValue(), locZ.doubleValue());
            replace.put("sender", teleporter);
            replace.put("loc", "Location: x=" + x + ", y=" + y + ", z=" + z);
            this.doTeleportAndMessage(players, replace, to);
        } else if (Utils.isPlayer(sender, false)) {
            Player p = (Player)sender;
            to = p.getLocation();
            replace.put("sender", teleporter);
            replace.put("loc", Utils.getPlayerName((Player)sender));
            this.doTeleportAndMessage(p, players, replace, to);
        } else {
            replace.put("arg", "world");
            replace.put("cmdName", "/tpall");
            LocaleHelper.MISSING_ARG.sendLocale(sender, replace);
            return;
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null && args.length >= 1;
    }

    private void doTeleportAndMessage(Player[] players, HashMap<String, String> replace, Location loc) {
        if (loc == null) {
            return;
        }
        if (players == null) {
            return;
        }
        for (Player p : players) {
            if (p == null) continue;
            p.teleport(loc);
            replace.clear();
            LocaleHelper.TP_ALL.sendLocale((CommandSender)p, replace);
        }
    }

    private void doTeleportAndMessage(Player sender, Player[] players, HashMap<String, String> replace, Location loc) {
        if (loc == null) {
            return;
        }
        if (players == null) {
            return;
        }
        for (Player p : players) {
            if (p == null || p == sender) continue;
            p.teleport(loc);
            replace.clear();
            LocaleHelper.TP_ALL.sendLocale((CommandSender)p, replace);
        }
    }

    private void parseNumber(CommandSender sender, String toParse, Double parsed) {
        try {
            parsed = Integer.parseInt(toParse);
        }
        catch (NumberFormatException e) {
            Utils.sI18n(sender, "NaN", "number", toParse);
            return;
        }
    }
}

