/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Server;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Server.ServerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Exceptions.WorldNotLoaded;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Tools.Utils;
import be.Balor.World.ACWorld;
import java.util.HashMap;
import org.bukkit.Difficulty;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WorldDifficulty
extends ServerCommand {
    public WorldDifficulty() {
        this.cmdName = "bal_difficulty";
        this.permNode = "admincmd.server.difficulty";
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        int difValue;
        ACWorld world;
        block13: {
            world = null;
            boolean worldGiven = false;
            difValue = -1;
            try {
                try {
                    difValue = args.getInt(0);
                }
                catch (NumberFormatException e) {
                    worldGiven = true;
                }
                if (args.length >= 1 && worldGiven) {
                    world = ACWorld.getWorld(args.getString(0));
                    break block13;
                }
                if (Utils.isPlayer(sender, false)) {
                    world = ACWorld.getWorld(((Player)sender).getWorld().getName());
                    break block13;
                }
                HashMap<String, String> replace = new HashMap<String, String>();
                replace.put("argument", "world");
                Utils.sI18n(sender, "errorInsufficientArguments", replace);
                return;
            }
            catch (WorldNotLoaded e) {
                Utils.sI18n(sender, "worldNotFound");
                return;
            }
        }
        Difficulty toSet = Difficulty.NORMAL;
        HashMap<String, String> replace = new HashMap<String, String>();
        if (args.hasFlag('g')) {
            replace.put("world", world.getName());
            replace.put("difficulty", world.getDifficulty().toString());
            Utils.sI18n(sender, "getDifficulty", replace);
        } else if (args.hasFlag('s')) {
            if (args.length >= 2) {
                toSet = Difficulty.getByValue((int)args.getInt(1));
            } else if (difValue != -1) {
                toSet = Difficulty.getByValue((int)difValue);
            }
            if (toSet == null) {
                toSet = Difficulty.NORMAL;
            }
            replace.put("world", world.getName());
            replace.put("difficulty", toSet.toString());
            world.setDifficulty(toSet);
            Utils.sI18n(sender, "setDifficulty", replace);
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null && args.length >= 1;
    }
}

