/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Server;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Server.ServerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Tools.Debug.ACLogger;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class LockServer
extends ServerCommand {
    public LockServer() {
        super("bal_lockdown", "admincmd.server.lock");
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        if (ACHelper.getInstance().isServerLocked()) {
            ACHelper.getInstance().setServerLocked(false);
            Utils.sI18n(sender, "serverUnlock");
        } else {
            String bcast = Utils.I18n("serverLock");
            if (bcast != null) {
                Utils.broadcastMessage(bcast);
                ACLogger.info(bcast);
            }
            ACHelper.getInstance().setServerLocked(true);
            final List<Player> onlinePlayers = Utils.getOnlinePlayers();
            ACPluginManager.getScheduler().scheduleSyncDelayedTask((Plugin)this.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    for (Player p : onlinePlayers) {
                        if (PermissionManager.hasPerm((CommandSender)p, "admincmd.server.lockdown")) continue;
                        p.kickPlayer(Utils.I18n("serverLockMessage"));
                    }
                }
            }, 100L);
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return true;
    }

    @Override
    public void registerBukkitPerm() {
        this.plugin.getPermissionLinker().addPermChild("admincmd.server.lockdown");
        super.registerBukkitPerm();
    }
}

