/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Server;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Server.ServerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Tools.Help.HelpLister;
import be.Balor.Tools.Help.String.ACMinecraftFontWidthCalculator;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.LocaleHelper;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class Help
extends ServerCommand {
    public Help() {
        this.permNode = "admincmd.server.help";
        this.cmdName = "bal_help";
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        if (args.length == 0) {
            HelpLister.getInstance().sendHelpPage("AdminCmd", 1, sender);
            return;
        }
        if (args.getString(0).equalsIgnoreCase("list") || args.getString(0).equalsIgnoreCase("plugins")) {
            String msg = "";
            sender.sendMessage(ChatColor.DARK_AQUA + ACMinecraftFontWidthCalculator.strPadCenterChat(ChatColor.WHITE + " Plugins " + ChatColor.DARK_AQUA, '-'));
            for (String plugin : HelpLister.getInstance().getPluginList()) {
                msg = msg + plugin + ", ";
            }
            if (!msg.equals("")) {
                if (msg.endsWith(", ")) {
                    msg = msg.substring(0, msg.lastIndexOf(","));
                }
                sender.sendMessage(msg);
            }
            return;
        }
        String cmd = args.getValueFlag('s');
        if (cmd != null) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("type", LocaleHelper.TYPE_CMD.getLocale());
            replace.put("value", cmd);
            if (!HelpLister.getInstance().sendHelpCmd(args.getString(0), cmd, sender)) {
                LocaleHelper.DONT_EXISTS.sendLocale(sender, replace);
            }
            return;
        }
        String cmd2 = args.getValueFlag('d');
        if (cmd2 != null) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("type", LocaleHelper.TYPE_CMD.getLocale());
            replace.put("value", cmd2);
            if (!HelpLister.getInstance().sendHelpCmd(args.getString(0), cmd2, sender, true)) {
                LocaleHelper.DONT_EXISTS.sendLocale(sender, replace);
            }
            return;
        }
        int page = 1;
        try {
            page = args.getInt(0);
            HelpLister.getInstance().sendHelpPage("AdminCmd", page, sender);
        }
        catch (NumberFormatException e) {
            if (args.length == 1) {
                if (!HelpLister.getInstance().sendHelpPage(args.getString(0), 1, sender)) {
                    Utils.sI18n(sender, "pluginNotFound", "plugin", args.getString(0));
                }
            }
            try {
                page = args.getInt(1);
                if (!HelpLister.getInstance().sendHelpPage(args.getString(0), page, sender)) {
                    Utils.sI18n(sender, "pluginNotFound", "plugin", args.getString(0));
                }
            }
            catch (NumberFormatException e1) {
                Utils.sI18n(sender, "NaN", "number", args.getString(1));
            }
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }
}

