/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Player.PlayerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.Threads.RemovePowerTask;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Vulcan
extends PlayerCommand {
    public Vulcan() {
        this.permNode = "admincmd.player.vulcan";
        this.cmdName = "bal_vulcan";
        this.other = true;
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        Player player = null;
        float power = ConfigEnum.DVULCAN.getFloat();
        String timeOut = args.getValueFlag('t');
        if (args.length >= 1) {
            try {
                player = Utils.getUser(sender, args, this.permNode, 1, false);
                power = args.getFloat(0);
            }
            catch (NumberFormatException e) {
                power = ConfigEnum.DVULCAN.getFloat();
                player = Utils.getUser(sender, args, this.permNode);
            }
            if (args.length >= 2) {
                player = Utils.getUser(sender, args, this.permNode, 1, true);
            }
        } else {
            player = Utils.getUser(sender, args, this.permNode);
        }
        if (player != null) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("player", Utils.getPlayerName(player));
            ACPlayer acp = ACPlayer.getPlayer(player.getName());
            if (acp.hasPower(Type.VULCAN)) {
                acp.removePower(Type.VULCAN);
                Utils.sI18n((CommandSender)player, "vulcanDisabled");
                if (!player.equals(sender)) {
                    Utils.sI18n(sender, "vulcanDisabledTarget", replace);
                }
            } else {
                int timeOutValue;
                acp.setPower(Type.VULCAN, Float.valueOf(power));
                Utils.sI18n((CommandSender)player, "vulcanEnabled");
                if (!player.equals(sender)) {
                    Utils.sI18n(sender, "vulcanEnabledTarget", replace);
                }
                if (timeOut == null) {
                    return;
                }
                try {
                    timeOutValue = Integer.parseInt(timeOut);
                }
                catch (Exception e) {
                    Utils.sI18n(sender, "NaN", "number", timeOut);
                    return;
                }
                ACPluginManager.getScheduler().scheduleAsyncDelayedTask((Plugin)ACPluginManager.getCorePlugin(), (Runnable)new RemovePowerTask(acp, Type.VULCAN, sender), (long)(20 * ConfigEnum.SCALE_TIMEOUT.getInt() * timeOutValue));
            }
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }
}

