/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Player.PlayerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Player.BannedPlayer;
import be.Balor.Player.IBan;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.LocaleHelper;
import java.util.HashMap;
import org.bukkit.command.CommandSender;

public class UnBan
extends PlayerCommand {
    public UnBan() {
        this.permNode = "admincmd.player.ban";
        this.cmdName = "bal_unban";
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        String unban = args.getString(0);
        IBan ban = ACHelper.getInstance().getBan(unban);
        if (ban != null) {
            if (ban instanceof BannedPlayer && !Utils.checkImmunity(sender, args, 0)) {
                Utils.sI18n(sender, "insufficientLvl");
                return;
            }
            ACHelper.getInstance().unBanPlayer(ban);
            String unbanMsg = Utils.I18n("unban", "player", unban);
            if (unbanMsg != null) {
                Utils.broadcastMessage(unbanMsg);
            }
        } else {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("ban", unban);
            LocaleHelper.NO_BAN_FOUND.sendLocale(sender, replace);
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null && args.length >= 1;
    }
}

