/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Player.PlayerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.Debug.ACLogger;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import be.Balor.bukkit.AdminCmd.LocaleHelper;
import belgium.Balor.Workers.AFKWorker;
import belgium.Balor.Workers.InvisibleWorker;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Reply
extends PlayerCommand {
    public Reply() {
        this.permNode = "admincmd.player.reply";
        this.cmdName = "bal_reply";
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        if (!Utils.isPlayer(sender, true)) {
            return;
        }
        if (Utils.isPlayer(sender, false) && ACPlayer.getPlayer((Player)sender).hasPower(Type.MUTED) && ConfigEnum.MUTEDPM.getBoolean()) {
            Utils.sI18n(sender, "muteEnabled");
            return;
        }
        Player pSender = (Player)sender;
        Player buddy = ACHelper.getInstance().getReplyPlayer(pSender);
        if (buddy != null) {
            if (!buddy.isOnline()) {
                Utils.sI18n(sender, "offline");
                ACHelper.getInstance().removeReplyPlayer(pSender);
                return;
            }
            if (InvisibleWorker.getInstance().hasInvisiblePowers(buddy) && !PermissionManager.hasPerm(sender, "admincmd.invisible.cansee", false)) {
                Utils.sI18n(sender, "playerNotFound", "player", args.getString(0));
                return;
            }
            String senderPm = "";
            String msg = "";
            String senderName = "";
            senderName = pSender.getName();
            senderPm = Utils.getPlayerName(pSender, (CommandSender)buddy) + ChatColor.WHITE + " - ";
            for (String arg : args) {
                msg = msg + arg + " ";
            }
            String parsed = Utils.colorParser(msg = msg.trim());
            if (parsed == null) {
                parsed = msg;
            }
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("sender", senderPm);
            replace.put("receiver", Utils.getPlayerName(buddy));
            buddy.sendMessage(Utils.I18n("privateMessageHeader", replace) + parsed);
            ACHelper.getInstance().setReplyPlayer(buddy, pSender);
            if (AFKWorker.getInstance().isAfk(buddy)) {
                AFKWorker.getInstance().sendAfkMessage(sender, buddy);
            } else {
                sender.sendMessage(Utils.I18n("privateMessageHeader", replace) + parsed);
            }
            String spyMsg = LocaleHelper.SPYMSG_HEADER.getLocale(replace) + parsed;
            for (Player p : ACHelper.getInstance().getSpyPlayers()) {
                if (p == null || p.getName().equals(senderName) || p.getName().equals(buddy.getName())) continue;
                p.sendMessage(spyMsg);
            }
            if (ConfigEnum.LOG_PM.getBoolean()) {
                ACLogger.info(spyMsg);
            }
        } else {
            Utils.sI18n(sender, "noPlayerToReply");
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null && args.length >= 1;
    }
}

