/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Player.PlayerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.Debug.ACLogger;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import be.Balor.bukkit.AdminCmd.LocaleHelper;
import belgium.Balor.Workers.AFKWorker;
import belgium.Balor.Workers.InvisibleWorker;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class PrivateMessage
extends PlayerCommand {
    public PrivateMessage() {
        this.permNode = "admincmd.player.msg";
        this.cmdName = "bal_playermsg";
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        if (Utils.isPlayer(sender, false) && ACPlayer.getPlayer((Player)sender).hasPower(Type.MUTED) && ConfigEnum.MUTEDPM.getBoolean()) {
            Utils.sI18n(sender, "muteEnabled");
            return;
        }
        Player buddy = sender.getServer().getPlayer(args.getString(0));
        if (buddy != null) {
            if (InvisibleWorker.getInstance().hasInvisiblePowers(buddy) && !PermissionManager.hasPerm(sender, "admincmd.invisible.cansee", false)) {
                Utils.sI18n(sender, "playerNotFound", "player", args.getString(0));
                return;
            }
            String senderPm = "";
            String msg = "";
            String senderName = "Server Admin";
            if (Utils.isPlayer(sender, false)) {
                Player pSender = (Player)sender;
                senderName = pSender.getName();
                senderPm = Utils.getPlayerName(pSender, (CommandSender)buddy);
                ACHelper.getInstance().setReplyPlayer(buddy, pSender);
            } else {
                senderPm = senderName;
            }
            for (int i = 1; i < args.length; ++i) {
                msg = msg + args.getString(i) + " ";
            }
            String parsed = Utils.colorParser(msg = msg.trim());
            if (parsed == null) {
                parsed = msg;
            }
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("sender", senderPm);
            replace.put("receiver", Utils.getPlayerName(buddy));
            buddy.sendMessage(Utils.I18n("privateMessageHeader", replace) + parsed);
            if (AFKWorker.getInstance().isAfk(buddy)) {
                AFKWorker.getInstance().sendAfkMessage(sender, buddy);
            } else {
                sender.sendMessage(Utils.I18n("privateMessageHeader", replace) + parsed);
            }
            String spyMsg = LocaleHelper.SPYMSG_HEADER.getLocale(replace) + parsed;
            for (Player p : ACHelper.getInstance().getSpyPlayers()) {
                if (p == null || p.getName().equals(senderName) || p.getName().equals(buddy.getName())) continue;
                p.sendMessage(spyMsg);
            }
            if (ConfigEnum.LOG_PM.getBoolean() && !(sender instanceof ConsoleCommandSender)) {
                ACLogger.info(spyMsg);
            }
        } else {
            Utils.sI18n(sender, "playerNotFound", "player", args.getString(0));
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null && args.length >= 2;
    }
}

