/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Player.PlayerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Tools.Help.String.Str;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.LocaleHelper;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Potion
extends PlayerCommand {
    private static final List<String> potions = new ArrayList<String>();

    public Potion() {
        super("bal_potion", "admincmd.player.potion");
        this.other = true;
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws PlayerNotFound, ActionNotPermitedException {
        Player target = Utils.getUserParam(sender, args, this.permNode);
        String potion = args.getString(0);
        String potionFound = Str.matchString(potions, potion);
        HashMap<String, String> replace = new HashMap<String, String>();
        if (potionFound == null) {
            replace.put("value", potion);
            replace.put("type", LocaleHelper.TYPE_POTION.getLocale());
            LocaleHelper.DONT_EXISTS.sendLocale(sender, replace);
            sender.sendMessage(ChatColor.GREEN + "Potion list :");
            sender.sendMessage(Joiner.on((String)", ").skipNulls().join(potions).toLowerCase());
            return;
        }
        String potionDurationString = args.getString(1);
        String potionAmplifierString = args.getString(2);
        int amplifier = 5;
        int duration = 400;
        if (potionAmplifierString != null) {
            try {
                amplifier = Integer.parseInt(potionAmplifierString);
            }
            catch (NumberFormatException e) {
                Utils.sI18n(sender, "NaN", "number", potionAmplifierString);
                return;
            }
        }
        if (potionDurationString != null) {
            try {
                duration = Integer.parseInt(potionDurationString);
            }
            catch (NumberFormatException e) {
                Utils.sI18n(sender, "NaN", "number", potionDurationString);
                return;
            }
        }
        target.addPotionEffect(new PotionEffect(PotionEffectType.getByName((String)potionFound), duration, amplifier));
        replace.put("player", Utils.getPlayerName(target, sender));
        replace.put("potion", potionFound);
        LocaleHelper.POTION_EFFECT.sendLocale(sender, replace);
        if (!target.equals(sender)) {
            LocaleHelper.POTION_EFFECT.sendLocale((CommandSender)target, replace);
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }

    static {
        for (PotionEffectType type : PotionEffectType.values()) {
            if (type == null || type.getName() == null) continue;
            potions.add(type.getName());
        }
    }
}

