/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Player.PlayerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.Threads.RemovePowerTask;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class NoPickup
extends PlayerCommand {
    public NoPickup() {
        this.permNode = "admincmd.player.nopickup";
        this.cmdName = "bal_np";
        this.other = true;
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        String timeOut = args.getValueFlag('t');
        Player player = Utils.getUser(sender, args, this.permNode);
        if (player != null) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("player", Utils.getPlayerName(player));
            ACPlayer acp = ACPlayer.getPlayer(player);
            if (acp.hasPower(Type.NO_PICKUP)) {
                acp.removePower(Type.NO_PICKUP);
                Utils.sI18n((CommandSender)player, "npDisabled");
                if (!player.equals(sender)) {
                    Utils.sI18n(sender, "npDisabledTarget", replace);
                }
            } else {
                int timeOutValue;
                acp.setPower(Type.NO_PICKUP);
                Utils.sI18n((CommandSender)player, "npEnabled");
                if (!player.equals(sender)) {
                    Utils.sI18n(sender, "npEnabledTarget", replace);
                }
                if (timeOut == null) {
                    return;
                }
                try {
                    timeOutValue = Integer.parseInt(timeOut);
                }
                catch (Exception e) {
                    Utils.sI18n(sender, "NaN", "number", timeOut);
                    return;
                }
                ACPluginManager.getScheduler().scheduleAsyncDelayedTask((Plugin)ACPluginManager.getCorePlugin(), (Runnable)new RemovePowerTask(acp, Type.NO_PICKUP, sender), (long)(20 * ConfigEnum.SCALE_TIMEOUT.getInt() * timeOutValue));
            }
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }
}

