/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Player.PlayerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.LocaleManager;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.LocaleHelper;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class KickPlayer
extends PlayerCommand {
    public KickPlayer() {
        this.permNode = "admincmd.player.kick";
        this.cmdName = "bal_kick";
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        HashMap<String, String> replace = new HashMap<String, String>();
        Player toKick = sender.getServer().getPlayer(args.getString(0));
        if (toKick == null) {
            replace.put("player", args.getString(0));
            Utils.sI18n(sender, "playerNotFound", replace);
            return;
        }
        if (!Utils.checkImmunity(sender, toKick)) {
            Utils.sI18n(sender, "insufficientLvl");
            return;
        }
        String message = "";
        if (args.hasFlag('m')) {
            message = LocaleManager.getInstance().get("kickMessages", args.getValueFlag('m'), "player", toKick.getName());
        } else if (args.length >= 2) {
            for (int i = 1; i < args.length; ++i) {
                message = message + args.getString(i) + " ";
            }
        }
        if (message == null || message != null && message.isEmpty()) {
            message = "You have been kicked by ";
            message = !Utils.isPlayer(sender, false) ? message + "Server Admin" : message + Utils.getPlayerName((Player)sender);
        }
        ACPlayer.getPlayer(toKick).setPower(Type.KICKED);
        final String finalmsg = message.trim();
        final Player finalToKick = toKick;
        replace.put("player", Utils.getPlayerName(toKick));
        ACPluginManager.scheduleSyncTask(new Runnable(){

            @Override
            public void run() {
                finalToKick.kickPlayer(finalmsg);
            }
        });
        replace.put("reason", finalmsg);
        Utils.broadcastMessage(LocaleHelper.PLAYER_KICKED.getLocale(replace));
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null && args.length >= 1;
    }
}

