/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Player;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Player.PlayerCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.Threads.RemovePowerTask;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Fly
extends PlayerCommand {
    public Fly() {
        this.permNode = "admincmd.player.fly";
        this.cmdName = "bal_fly";
        this.other = true;
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        Player player = null;
        String timeOut = args.getValueFlag('t');
        try {
            player = Utils.getUserParam(sender, args, this.permNode);
        }
        catch (PlayerNotFound e) {
            sender.sendMessage(e.getMessage());
            return;
        }
        if (player != null) {
            if (args.hasFlag('o')) {
                this.setFly(sender, player, timeOut, Type.FLY_OLD, FlyMode.OLD, args);
            } else {
                this.setFly(sender, player, timeOut, Type.FLY, FlyMode.NEW, args);
            }
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }

    private void setFly(CommandSender sender, Player player, String timeOut, Type power, FlyMode c, CommandArgs args) {
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("player", Utils.getPlayerName(player));
        ACPlayer acp = ACPlayer.getPlayer(player);
        String powerValueString = args.getValueFlag('p');
        float powerFloat = 0.0f;
        if (powerValueString != null) {
            try {
                powerFloat = Float.parseFloat(powerValueString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        float f = powerFloat = powerFloat > ConfigEnum.MAX_FLY.getFloat() ? ConfigEnum.MAX_FLY.getFloat() : powerFloat;
        if (acp.hasPower(power)) {
            acp.removePower(power);
            player.setAllowFlight(false);
            if (c == FlyMode.NEW) {
                player.setFlying(false);
            }
            player.setFallDistance(0.0f);
            Utils.sI18n((CommandSender)player, "flyDisabled");
            if (!player.equals(sender)) {
                Utils.sI18n(sender, "flyDisabledTarget", replace);
            }
        } else {
            int timeOutValue;
            player.setAllowFlight(true);
            if (c == FlyMode.NEW) {
                player.setFlying(true);
                acp.setPower(power, Float.valueOf(powerFloat));
            } else {
                acp.setPower(power, Float.valueOf(powerFloat == 0.0f ? ConfigEnum.DFLY.getFloat() : powerFloat));
            }
            player.setFallDistance(1.0f);
            Utils.sI18n((CommandSender)player, "flyEnabled");
            if (!player.equals(sender)) {
                Utils.sI18n(sender, "flyEnabledTarget", replace);
            }
            if (timeOut == null) {
                return;
            }
            try {
                timeOutValue = Integer.parseInt(timeOut);
            }
            catch (Exception e) {
                Utils.sI18n(sender, "NaN", "number", timeOut);
                return;
            }
            ACPluginManager.getScheduler().scheduleAsyncDelayedTask((Plugin)ACPluginManager.getCorePlugin(), (Runnable)new RemovePowerTask(acp, power, sender), (long)(20 * ConfigEnum.SCALE_TIMEOUT.getInt() * timeOutValue));
        }
    }

    private static enum FlyMode {
        OLD,
        NEW;

    }
}

