/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Mob;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Mob.MobCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Exceptions.WorldNotLoaded;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.server.EntityAnimal;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityMonster;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class KillMob
extends MobCommand {
    public KillMob() {
        this.permNode = "admincmd.mob.kill";
        this.cmdName = "bal_killmob";
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        HashMap<String, String> replace = new HashMap<String, String>();
        String type = "all";
        if (args.length >= 1) {
            type = args.getString(0);
        }
        replace.put("type", type);
        String worldString = args.getValueFlag('w');
        final ArrayList<World> worldList = new ArrayList<World>();
        if (Utils.isPlayer(sender, false)) {
            World w = ((Player)sender).getWorld();
            if (worldString != null) {
                w = this.getWorld(worldString);
            }
            worldList.add(w);
            replace.put("worlds", w.getName());
            Utils.sI18n(sender, "killMob", replace);
        } else if (worldString != null) {
            worldList.add(this.getWorld(worldString));
        } else {
            String worlds = "";
            for (World world : sender.getServer().getWorlds()) {
                worldList.add(world);
                worlds = worlds + world.getName() + ", ";
            }
            if (!worlds.equals("")) {
                if (worlds.endsWith(", ")) {
                    worlds = worlds.substring(0, worlds.lastIndexOf(","));
                }
                replace.put("worlds", worlds);
                Utils.sI18n(sender, "killMob", replace);
            }
        }
        final String finalType = type;
        final CommandSender finalSender = sender;
        ACPluginManager.getScheduler().scheduleAsyncDelayedTask((Plugin)ACPluginManager.getCorePlugin(), new Runnable(){

            @Override
            public void run() {
                KillMob.this.killMobs(worldList, finalType, finalSender);
            }
        });
    }

    private World getWorld(String name) {
        World w = Bukkit.getWorld((String)name);
        if (w == null) {
            throw new WorldNotLoaded("The World " + name + " is not loaded");
        }
        return w;
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }

    private void killMobs(List<World> worlds, String type, CommandSender sender) {
        int mobKilled = 0;
        if (type.equalsIgnoreCase("all")) {
            for (World w : worlds) {
                for (LivingEntity m : w.getLivingEntities()) {
                    if (m instanceof HumanEntity) continue;
                    EntityLiving entity = ((CraftLivingEntity)m).getHandle();
                    entity.die();
                    ++mobKilled;
                }
            }
        } else if (type.equalsIgnoreCase("monsters")) {
            for (World w : worlds) {
                for (LivingEntity m : w.getLivingEntities()) {
                    if (!(m instanceof EntityMonster)) continue;
                    EntityLiving entity = ((CraftLivingEntity)m).getHandle();
                    entity.die();
                    ++mobKilled;
                }
            }
        } else if (type.equalsIgnoreCase("animals")) {
            for (World w : worlds) {
                for (LivingEntity m : w.getLivingEntities()) {
                    if (!(m instanceof EntityAnimal)) continue;
                    EntityLiving entity = ((CraftLivingEntity)m).getHandle();
                    entity.die();
                    ++mobKilled;
                }
            }
        } else {
            EntityType ct = null;
            ct = EntityType.fromName((String)type);
            if (ct == null) {
                HashMap<String, String> replace = new HashMap<String, String>();
                replace.put("mob", type);
                Utils.sI18n(sender, "errorMob", replace);
                return;
            }
            for (World w : worlds) {
                for (Entity m : w.getEntitiesByClasses(new Class[]{ct.getEntityClass()})) {
                    net.minecraft.server.Entity entity = ((CraftEntity)m).getHandle();
                    entity.die();
                    ++mobKilled;
                }
            }
        }
        Utils.sI18n(sender, "killedMobs", "nbKilled", String.valueOf(mobKilled));
    }
}

