/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Mob;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Mob.MobCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.Debug.ACLogger;
import be.Balor.Tools.Egg.EggPermissionManager;
import be.Balor.Tools.Egg.EggType;
import be.Balor.Tools.Egg.Exceptions.DontHaveThePermissionException;
import be.Balor.Tools.Egg.Exceptions.ExceptionType;
import be.Balor.Tools.Egg.Exceptions.ParameterMissingException;
import be.Balor.Tools.Egg.Exceptions.ProcessingArgsException;
import be.Balor.Tools.Egg.Types.NormalEgg;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import com.google.common.base.Joiner;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EggSpawner
extends MobCommand {
    public EggSpawner() {
        this.cmdName = "bal_egg";
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        if (!Utils.isPlayer(sender)) {
            return;
        }
        Player player = (Player)sender;
        ACPlayer acp = ACPlayer.getPlayer(player);
        EggType<?> egg = null;
        try {
            egg = EggType.createEggType(player, args);
        }
        catch (ParameterMissingException e) {
            if (e.getParam() == 'E') {
                String list = Joiner.on((String)", ").skipNulls().join(EggPermissionManager.INSTANCE.getEggTypeNames(player));
                sender.sendMessage(e.getMessage());
                sender.sendMessage(ChatColor.GOLD + "Egg List : ");
                sender.sendMessage(ChatColor.YELLOW + list);
            } else {
                Utils.sI18n(sender, "paramMissing", "param", String.valueOf(e.getParam()));
                sender.sendMessage(e.getMessage());
            }
            return;
        }
        catch (ProcessingArgsException e) {
            if (e.getType().equals((Object)ExceptionType.NO_CLASS)) {
                Utils.sI18n(sender, "eggDontExists", "egg", e.getMessage());
            } else if (e.getType().equals((Object)ExceptionType.DONT_EXISTS)) {
                Utils.sI18n(sender, "entityDontExists", "entity", e.getMessage());
            } else if (e.getType().equals((Object)ExceptionType.CUSTOM)) {
                HashMap<String, String> replace = new HashMap<String, String>();
                replace.put("egg", args.getValueFlag('E'));
                replace.put("error", e.getMessage());
                Utils.sI18n(sender, "eggCustomError", replace);
            } else {
                ACLogger.severe("Problem with an Egg Type : " + e.getMessage(), e);
            }
            return;
        }
        catch (DontHaveThePermissionException e) {
            sender.sendMessage(e.getMessage());
            return;
        }
        catch (NullPointerException e) {
            if (args.hasFlag('E')) {
                String list = Joiner.on((String)", ").skipNulls().join(EggPermissionManager.INSTANCE.getEggTypeNames(player));
                sender.sendMessage(ChatColor.GOLD + "Egg List : ");
                sender.sendMessage(ChatColor.YELLOW + list);
            } else {
                Utils.sI18n(sender, "eggNoParamGiven");
                sender.sendMessage(e.getMessage());
            }
            return;
        }
        if (egg instanceof NormalEgg) {
            acp.removePower(Type.EGG);
            Utils.sI18n(sender, "eggNormal");
        } else {
            acp.setPower(Type.EGG, egg);
            Utils.sI18n(sender, "eggEnabled", "egg", egg.toString());
        }
    }

    @Override
    public boolean permissionCheck(CommandSender sender) {
        return true;
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }
}

