/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Mob;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Mob.MobCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class ChangeMobSpawner
extends MobCommand {
    public ChangeMobSpawner() {
        this.permNode = "admincmd.mob.spawner";
        this.cmdName = "bal_changespawner";
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        if (Utils.isPlayer(sender)) {
            HashMap<String, String> replace = new HashMap<String, String>();
            Player player = (Player)sender;
            Block block = player.getTargetBlock(null, 100);
            if (block.getTypeId() != Material.MOB_SPAWNER.getId()) {
                player.sendMessage("Not a Mob Spawner");
                return;
            }
            final CreatureSpawner spawner = (CreatureSpawner)block.getState();
            if (args.hasFlag('m')) {
                String name = args.getString(0);
                if (name == null) {
                    return;
                }
                final EntityType type = EntityType.fromName((String)name);
                if (type == null) {
                    replace.put("mob", args.getString(0));
                    Utils.sI18n(sender, "errorMob", replace);
                }
                ACPluginManager.scheduleSyncTask(new Runnable(){

                    @Override
                    public void run() {
                        spawner.setCreatureTypeByName(type.getName());
                    }
                });
                replace.put("type", args.getString(0));
                Utils.sI18n(sender, "spawnerSetType", replace);
            } else if (args.hasFlag('d')) {
                int delay;
                try {
                    delay = args.getInt(0);
                }
                catch (Exception e) {
                    Utils.sI18n(sender, "spawnerNaN");
                    return;
                }
                final int fDelay = delay;
                ACPluginManager.scheduleSyncTask(new Runnable(){

                    @Override
                    public void run() {
                        spawner.setDelay(fDelay);
                    }
                });
                replace.put("delay", String.valueOf(args.getInt(0)));
                Utils.sI18n(sender, "spawnerSetDelay", replace);
            } else if (args.hasFlag('g')) {
                int delay = spawner.getDelay();
                String type = spawner.getCreatureTypeName();
                replace.put("mob", type);
                replace.put("delay", String.valueOf(delay));
                Utils.sI18n(sender, "spawnerGetData", replace);
            }
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }
}

