/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Items;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Items.ItemCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Repair
extends ItemCommand {
    public Repair() {
        this.permNode = "admincmd.item.repair";
        this.cmdName = "bal_repair";
        this.other = true;
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        if (Utils.isPlayer(sender)) {
            Player player = Utils.getUser(sender, args, this.permNode);
            if (player == null) {
                return;
            }
            final ItemStack item = player.getItemInHand();
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("type", item.getType().toString());
            if (item != null && ACHelper.getInstance().repairable(item.getTypeId())) {
                ACPluginManager.scheduleSyncTask(new Runnable(){

                    @Override
                    public void run() {
                        item.setDurability((short)0);
                    }
                });
                replace.put("player", Utils.getPlayerName(player));
                if (!sender.equals(player)) {
                    Utils.sI18n(sender, "repair", replace);
                }
                Utils.sI18n((CommandSender)player, "repairTarget", replace);
            } else {
                Utils.sI18n(sender, "errorRepair", replace);
            }
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }
}

