/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Items;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Items.ItemCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Manager.Permissions.PermChild;
import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.Files.ArmoredKitInstance;
import be.Balor.Tools.Files.KitInstance;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Kit
extends ItemCommand {
    public Kit() {
        this.cmdName = "bal_kit";
        this.other = true;
    }

    @Override
    public boolean permissionCheck(CommandSender sender) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        if (args.length == 0) {
            Utils.sI18n(sender, "kitList", "list", ACHelper.getInstance().getKitList(sender));
            return;
        }
        KitInstance kit = ACHelper.getInstance().getKit(args.getString(0));
        if (kit == null) {
            Utils.sI18n(sender, "kitNotFound", "kit", args.getString(0));
            return;
        }
        Player target = Utils.getUser(sender, args, this.permNode, 1, true);
        if (target == null) {
            return;
        }
        if (!PermissionManager.hasPerm(sender, "admincmd.kit." + args.getString(0))) {
            return;
        }
        ACPlayer actarget = ACPlayer.getPlayer(target);
        if (!PermissionManager.hasPerm(sender, "admincmd.item.nodelay", false)) {
            int kitDelay = kit.getDelay();
            long kitLastUse = actarget.getLastKitUse(kit.getName());
            if (kitDelay == -1) {
                if (kitLastUse != 0L) {
                    Utils.sI18n(sender, "kitOnce", "kit", kit.getName());
                    return;
                }
                actarget.updateLastKitUse(kit.getName());
            } else {
                long nextuse = kitLastUse + (long)kitDelay * 1000L;
                long now = System.currentTimeMillis();
                if (now < nextuse) {
                    long diff = nextuse - now;
                    Long[] timeLeft = Utils.transformToElapsedTime(diff);
                    HashMap<String, String> replace = new HashMap<String, String>();
                    replace.put("d", timeLeft[0].toString());
                    replace.put("h", timeLeft[1].toString());
                    replace.put("m", timeLeft[2].toString());
                    replace.put("s", timeLeft[3].toString());
                    String timestamp = (timeLeft[0] > 0L ? Utils.I18n("days", "d", timeLeft[0].toString()) : "") + (timeLeft[1] > 0L ? timeLeft[1] + "h " : "") + (timeLeft[2] > 0L ? timeLeft[2] + "m " : "") + (timeLeft[3] > 0L ? timeLeft[3] + "s" : "");
                    Utils.sI18n(sender, "kitDelayNotUp", "delay", timestamp);
                    return;
                }
                actarget.updateLastKitUse(kit.getName());
            }
        }
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("kit", args.getString(0));
        if (Utils.isPlayer(sender, false)) {
            if (!target.equals(sender)) {
                replace.put("sender", Utils.getPlayerName((Player)sender));
                Utils.sI18n((CommandSender)target, "kitOtherPlayer", replace);
                replace.remove("sender");
                replace.put("target", Utils.getPlayerName(target));
                Utils.sI18n(sender, "kitCommandSender", replace);
            } else {
                Utils.sI18n(sender, "kitYourself", replace);
            }
        } else {
            replace.put("sender", "Server Admin");
            Utils.sI18n((CommandSender)target, "kitOtherPlayer", replace);
            replace.remove("sender");
            replace.put("target", Utils.getPlayerName(target));
            Utils.sI18n(sender, "kitCommandSender", replace);
        }
        final ItemStack[] items = kit.getItemStacks().toArray(new ItemStack[0]);
        final Player taskTarget = target;
        ACPluginManager.scheduleSyncTask(new Runnable(){

            @Override
            public void run() {
                taskTarget.getInventory().addItem(items);
            }
        });
        if (kit instanceof ArmoredKitInstance) {
            ((ArmoredKitInstance)kit).setPlayerArmorParts(target);
        }
    }

    @Override
    public void registerBukkitPerm() {
        this.permParent.addChild(new PermChild("admincmd.item.nodelay", this.bukkitDefault)).addChild(new PermChild("admincmd.item.kithelp", this.bukkitDefault));
        super.registerBukkitPerm();
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }
}

