/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Items;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Items.ItemCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Tools.MaterialContainer;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Drop
extends ItemCommand {
    public Drop() {
        this.permNode = "admincmd.item.drop";
        this.cmdName = "bal_drop";
        this.other = true;
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        MaterialContainer mat = null;
        mat = ACHelper.getInstance().checkMaterial(sender, args.getString(0));
        if (mat.isNull()) {
            return;
        }
        if (ACHelper.getInstance().inBlackListItem(sender, mat)) {
            return;
        }
        if (mat.getMaterial().equals((Object)Material.AIR)) {
            Utils.sI18n(sender, "airForbidden");
            return;
        }
        int cnt = 1;
        Player target = null;
        if (args.length >= 2) {
            try {
                cnt = args.getInt(1);
            }
            catch (Exception e) {
                return;
            }
            if (cnt > ACHelper.getInstance().getLimit(sender, Type.Limit.MAX_ITEMS) && !sender.hasPermission("admincmd.item.infinity")) {
                HashMap<String, String> replace = new HashMap<String, String>();
                replace.put("limit", String.valueOf(ACHelper.getInstance().getLimit(sender, Type.Limit.MAX_ITEMS)));
                Utils.sI18n(sender, "itemLimit", replace);
                return;
            }
            if (args.length >= 3 && (target = Utils.getUser(sender, args, this.permNode, 2, true)) == null) {
                return;
            }
        }
        if (target == null) {
            if (Utils.isPlayer(sender)) {
                target = (Player)sender;
            } else {
                return;
            }
        }
        mat.setAmount(cnt);
        final ItemStack stack = mat.getItemStack();
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("amount", String.valueOf(mat.getAmount()));
        replace.put("material", mat.getMaterial().toString());
        if (Utils.isPlayer(sender, false)) {
            if (!target.equals(sender)) {
                replace.put("sender", Utils.getPlayerName((Player)sender));
                Utils.sI18n((CommandSender)target, "dropItemOtherPlayer", replace);
                replace.remove("sender");
                replace.put("target", Utils.getPlayerName(target));
                Utils.sI18n(sender, "dropItemCommandSender", replace);
            } else {
                Utils.sI18n(sender, "dropItemYourself", replace);
            }
        } else {
            replace.put("sender", "Server Admin");
            Utils.sI18n((CommandSender)target, "dropItemOtherPlayer", replace);
            replace.remove("sender");
            replace.put("target", Utils.getPlayerName(target));
            Utils.sI18n(sender, "dropItemCommandSender", replace);
        }
        final Player taskTarget = target;
        ACPluginManager.scheduleSyncTask(new Runnable(){

            @Override
            public void run() {
                taskTarget.getWorld().dropItem(taskTarget.getLocation(), stack);
            }
        });
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null && args.length >= 1;
    }
}

