/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Home;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Home.HomeCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.Utils;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ListHomes
extends HomeCommand {
    public ListHomes() {
        this.permNode = "admincmd.tp.home";
        this.cmdName = "bal_homelist";
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        if (Utils.isPlayer(sender)) {
            String msg = "";
            String player = "serverConsole";
            if (Utils.isPlayer(sender, false)) {
                player = ((Player)sender).getName();
            }
            if (args.length >= 1) {
                if (!PermissionManager.hasPerm(sender, "admincmd.admin.home")) {
                    return;
                }
                player = args.getString(0);
            }
            Set<String> homes = ACPlayer.getPlayer(player).getHomeList();
            sender.sendMessage(ChatColor.GOLD + "Home(s) : " + ChatColor.WHITE + homes.size());
            for (String name : homes) {
                if ((msg = msg + name + ", ").length() < 318) continue;
                sender.sendMessage(msg);
                msg = "";
            }
            if (!msg.equals("")) {
                if (msg.endsWith(", ")) {
                    msg = msg.substring(0, msg.lastIndexOf(","));
                }
                sender.sendMessage(msg);
            }
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return true;
    }
}

